package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Path;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "uploadUrl", 
    "expirationDateTime", 
    "nextExpectedRanges"})
@JsonInclude(Include.NON_NULL)
public class UploadSession implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("uploadUrl")
    protected String uploadUrl;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("nextExpectedRanges")
    protected List<String> nextExpectedRanges;

    @JsonProperty("nextExpectedRanges@nextLink")
    protected String nextExpectedRangesNextLink;

    protected UploadSession() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.uploadSession";
    }

    @Property(name="uploadUrl")
    @JsonIgnore
    public Optional<String> getUploadUrl() {
        return Optional.ofNullable(uploadUrl);
    }

    public UploadSession withUploadUrl(String uploadUrl) {
        UploadSession _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.uploadSession");
        _x.uploadUrl = uploadUrl;
        return _x;
    }

    @Property(name="uploadUrl")
    public <T extends StreamUploader<T>> T put(UploadStrategy<T> strategy) {
        this.unmappedFields.put("uploadUrl@odata.mediaEditLink", uploadUrl);
        return strategy.builder(new ContextPath(contextPath.context(), new Path(uploadUrl, contextPath.context().service().getBasePath().style())), this, "uploadUrl").get();
    }

    @Property(name="uploadUrl")
    public StreamUploaderChunked putChunked() {
        return put(UploadStrategy.chunked());
    }

    @Property(name="uploadUrl")
    public StreamUploaderSingleCall put() {
        return put(UploadStrategy.singleCall());
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public UploadSession withExpirationDateTime(OffsetDateTime expirationDateTime) {
        UploadSession _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.uploadSession");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="nextExpectedRanges")
    @JsonIgnore
    public CollectionPage<String> getNextExpectedRanges() {
        return new CollectionPage<String>(contextPath, String.class, nextExpectedRanges, Optional.ofNullable(nextExpectedRangesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="nextExpectedRanges")
    @JsonIgnore
    public CollectionPage<String> getNextExpectedRanges(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, nextExpectedRanges, Optional.ofNullable(nextExpectedRangesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String uploadUrl;
        private OffsetDateTime expirationDateTime;
        private List<String> nextExpectedRanges;
        private String nextExpectedRangesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder uploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
            this.changedFields = changedFields.add("uploadUrl");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder nextExpectedRanges(List<String> nextExpectedRanges) {
            this.nextExpectedRanges = nextExpectedRanges;
            this.changedFields = changedFields.add("nextExpectedRanges");
            return this;
        }

        public Builder nextExpectedRanges(String... nextExpectedRanges) {
            return nextExpectedRanges(Arrays.asList(nextExpectedRanges));
        }

        public Builder nextExpectedRangesNextLink(String nextExpectedRangesNextLink) {
            this.nextExpectedRangesNextLink = nextExpectedRangesNextLink;
            this.changedFields = changedFields.add("nextExpectedRanges");
            return this;
        }

        public UploadSession build() {
            UploadSession _x = new UploadSession();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.uploadSession";
            _x.uploadUrl = uploadUrl;
            _x.expirationDateTime = expirationDateTime;
            _x.nextExpectedRanges = nextExpectedRanges;
            _x.nextExpectedRangesNextLink = nextExpectedRangesNextLink;
            return _x;
        }
    }

    private UploadSession _copy() {
        UploadSession _x = new UploadSession();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.uploadUrl = uploadUrl;
        _x.expirationDateTime = expirationDateTime;
        _x.nextExpectedRanges = nextExpectedRanges;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UploadSession[");
        b.append("uploadUrl=");
        b.append(this.uploadUrl);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("nextExpectedRanges=");
        b.append(this.nextExpectedRanges);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
