package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“A description of why an entity is unsupported.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "message", 
    "propertyName"})
@JsonInclude(Include.NON_NULL)
public class UnsupportedDeviceConfigurationDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("message")
    protected String message;

    @JsonProperty("propertyName")
    protected String propertyName;

    protected UnsupportedDeviceConfigurationDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unsupportedDeviceConfigurationDetail";
    }

    /**
     * <i>“A message explaining why an entity is unsupported.”</i>
     * 
     * @return property message
     */
    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code message} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“A message explaining why an entity is unsupported.”</i>
     * 
     * @param message
     *            new value of {@code message} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code message} field changed
     */
    public UnsupportedDeviceConfigurationDetail withMessage(String message) {
        UnsupportedDeviceConfigurationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unsupportedDeviceConfigurationDetail");
        _x.message = message;
        return _x;
    }

    /**
     * <i>“If message is related to a specific property in the original entity, then the
     * name of that property.”</i>
     * 
     * @return property propertyName
     */
    @Property(name="propertyName")
    @JsonIgnore
    public Optional<String> getPropertyName() {
        return Optional.ofNullable(propertyName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code propertyName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“If message is related to a specific property in the original entity, then the
     * name of that property.”</i>
     * 
     * @param propertyName
     *            new value of {@code propertyName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code propertyName} field changed
     */
    public UnsupportedDeviceConfigurationDetail withPropertyName(String propertyName) {
        UnsupportedDeviceConfigurationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unsupportedDeviceConfigurationDetail");
        _x.propertyName = propertyName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String message;
        private String propertyName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“A message explaining why an entity is unsupported.”</i>
         * 
         * @param message
         *            value of {@code message} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        /**
         * <i>“If message is related to a specific property in the original entity, then the
         * name of that property.”</i>
         * 
         * @param propertyName
         *            value of {@code propertyName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            this.changedFields = changedFields.add("propertyName");
            return this;
        }

        public UnsupportedDeviceConfigurationDetail build() {
            UnsupportedDeviceConfigurationDetail _x = new UnsupportedDeviceConfigurationDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.unsupportedDeviceConfigurationDetail";
            _x.message = message;
            _x.propertyName = propertyName;
            return _x;
        }
    }

    private UnsupportedDeviceConfigurationDetail _copy() {
        UnsupportedDeviceConfigurationDetail _x = new UnsupportedDeviceConfigurationDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.message = message;
        _x.propertyName = propertyName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnsupportedDeviceConfigurationDetail[");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("propertyName=");
        b.append(this.propertyName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
