package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowedResourceActions", 
    "excludedResourceActions", 
    "condition"})
@JsonInclude(Include.NON_NULL)
public class UnifiedRolePermission implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowedResourceActions")
    protected List<String> allowedResourceActions;

    @JsonProperty("allowedResourceActions@nextLink")
    protected String allowedResourceActionsNextLink;

    @JsonProperty("excludedResourceActions")
    protected List<String> excludedResourceActions;

    @JsonProperty("excludedResourceActions@nextLink")
    protected String excludedResourceActionsNextLink;

    @JsonProperty("condition")
    protected String condition;

    protected UnifiedRolePermission() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unifiedRolePermission";
    }

    @Property(name="allowedResourceActions")
    @JsonIgnore
    public CollectionPage<String> getAllowedResourceActions() {
        return new CollectionPage<String>(contextPath, String.class, allowedResourceActions, Optional.ofNullable(allowedResourceActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="allowedResourceActions")
    @JsonIgnore
    public CollectionPage<String> getAllowedResourceActions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, allowedResourceActions, Optional.ofNullable(allowedResourceActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="excludedResourceActions")
    @JsonIgnore
    public CollectionPage<String> getExcludedResourceActions() {
        return new CollectionPage<String>(contextPath, String.class, excludedResourceActions, Optional.ofNullable(excludedResourceActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludedResourceActions")
    @JsonIgnore
    public CollectionPage<String> getExcludedResourceActions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, excludedResourceActions, Optional.ofNullable(excludedResourceActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="condition")
    @JsonIgnore
    public Optional<String> getCondition() {
        return Optional.ofNullable(condition);
    }

    public UnifiedRolePermission withCondition(String condition) {
        UnifiedRolePermission _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unifiedRolePermission");
        _x.condition = condition;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> allowedResourceActions;
        private String allowedResourceActionsNextLink;
        private List<String> excludedResourceActions;
        private String excludedResourceActionsNextLink;
        private String condition;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder allowedResourceActions(List<String> allowedResourceActions) {
            this.allowedResourceActions = allowedResourceActions;
            this.changedFields = changedFields.add("allowedResourceActions");
            return this;
        }

        public Builder allowedResourceActions(String... allowedResourceActions) {
            return allowedResourceActions(Arrays.asList(allowedResourceActions));
        }

        public Builder allowedResourceActionsNextLink(String allowedResourceActionsNextLink) {
            this.allowedResourceActionsNextLink = allowedResourceActionsNextLink;
            this.changedFields = changedFields.add("allowedResourceActions");
            return this;
        }

        public Builder excludedResourceActions(List<String> excludedResourceActions) {
            this.excludedResourceActions = excludedResourceActions;
            this.changedFields = changedFields.add("excludedResourceActions");
            return this;
        }

        public Builder excludedResourceActions(String... excludedResourceActions) {
            return excludedResourceActions(Arrays.asList(excludedResourceActions));
        }

        public Builder excludedResourceActionsNextLink(String excludedResourceActionsNextLink) {
            this.excludedResourceActionsNextLink = excludedResourceActionsNextLink;
            this.changedFields = changedFields.add("excludedResourceActions");
            return this;
        }

        public Builder condition(String condition) {
            this.condition = condition;
            this.changedFields = changedFields.add("condition");
            return this;
        }

        public UnifiedRolePermission build() {
            UnifiedRolePermission _x = new UnifiedRolePermission();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.unifiedRolePermission";
            _x.allowedResourceActions = allowedResourceActions;
            _x.allowedResourceActionsNextLink = allowedResourceActionsNextLink;
            _x.excludedResourceActions = excludedResourceActions;
            _x.excludedResourceActionsNextLink = excludedResourceActionsNextLink;
            _x.condition = condition;
            return _x;
        }
    }

    private UnifiedRolePermission _copy() {
        UnifiedRolePermission _x = new UnifiedRolePermission();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.allowedResourceActions = allowedResourceActions;
        _x.excludedResourceActions = excludedResourceActions;
        _x.condition = condition;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnifiedRolePermission[");
        b.append("allowedResourceActions=");
        b.append(this.allowedResourceActions);
        b.append(", ");
        b.append("excludedResourceActions=");
        b.append(this.excludedResourceActions);
        b.append(", ");
        b.append("condition=");
        b.append(this.condition);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
