package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.UnaryManagementConditionExpressionOperatorType;


/**
 * <i>“A management condition expression that is evaluated using a unary operation.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "operator", 
    "operand"})
@JsonInclude(Include.NON_NULL)
public class UnaryManagementConditionExpression extends ManagementConditionExpressionModel implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("operator")
    protected UnaryManagementConditionExpressionOperatorType operator;

    @JsonProperty("operand")
    protected ManagementConditionExpressionModel operand;

    protected UnaryManagementConditionExpression() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.unaryManagementConditionExpression";
    }

    /**
     * <i>“The operator used in the evaluation of the unary operation.”</i>
     * 
     * @return property operator
     */
    @Property(name="operator")
    @JsonIgnore
    public Optional<UnaryManagementConditionExpressionOperatorType> getOperator() {
        return Optional.ofNullable(operator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operator} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The operator used in the evaluation of the unary operation.”</i>
     * 
     * @param operator
     *            new value of {@code operator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operator} field changed
     */
    public UnaryManagementConditionExpression withOperator(UnaryManagementConditionExpressionOperatorType operator) {
        UnaryManagementConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unaryManagementConditionExpression");
        _x.operator = operator;
        return _x;
    }

    /**
     * <i>“The operand of the unary operation.”</i>
     * 
     * @return property operand
     */
    @Property(name="operand")
    @JsonIgnore
    public Optional<ManagementConditionExpressionModel> getOperand() {
        return Optional.ofNullable(operand);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operand} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The operand of the unary operation.”</i>
     * 
     * @param operand
     *            new value of {@code operand} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operand} field changed
     */
    public UnaryManagementConditionExpression withOperand(ManagementConditionExpressionModel operand) {
        UnaryManagementConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.unaryManagementConditionExpression");
        _x.operand = operand;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUnaryManagementConditionExpression() {
        return new Builder();
    }

    public static final class Builder {
        private UnaryManagementConditionExpressionOperatorType operator;
        private ManagementConditionExpressionModel operand;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The operator used in the evaluation of the unary operation.”</i>
         * 
         * @param operator
         *            value of {@code operator} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operator(UnaryManagementConditionExpressionOperatorType operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("operator");
            return this;
        }

        /**
         * <i>“The operand of the unary operation.”</i>
         * 
         * @param operand
         *            value of {@code operand} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operand(ManagementConditionExpressionModel operand) {
            this.operand = operand;
            this.changedFields = changedFields.add("operand");
            return this;
        }

        public UnaryManagementConditionExpression build() {
            UnaryManagementConditionExpression _x = new UnaryManagementConditionExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.unaryManagementConditionExpression";
            _x.operator = operator;
            _x.operand = operand;
            return _x;
        }
    }

    private UnaryManagementConditionExpression _copy() {
        UnaryManagementConditionExpression _x = new UnaryManagementConditionExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.operator = operator;
        _x.operand = operand;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UnaryManagementConditionExpression[");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("operand=");
        b.append(this.operand);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
