package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.EmailType;

@JsonPropertyOrder({
    "@odata.type", 
    "type", 
    "otherLabel"})
@JsonInclude(Include.NON_NULL)
public class TypedEmailAddress extends EmailAddress implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("type")
    protected EmailType type;

    @JsonProperty("otherLabel")
    protected String otherLabel;

    protected TypedEmailAddress() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.typedEmailAddress";
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<EmailType> getType() {
        return Optional.ofNullable(type);
    }

    public TypedEmailAddress withType(EmailType type) {
        TypedEmailAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.typedEmailAddress");
        _x.type = type;
        return _x;
    }

    @Property(name="otherLabel")
    @JsonIgnore
    public Optional<String> getOtherLabel() {
        return Optional.ofNullable(otherLabel);
    }

    public TypedEmailAddress withOtherLabel(String otherLabel) {
        TypedEmailAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.typedEmailAddress");
        _x.otherLabel = otherLabel;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTypedEmailAddress() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String address;
        private EmailType type;
        private String otherLabel;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder type(EmailType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder otherLabel(String otherLabel) {
            this.otherLabel = otherLabel;
            this.changedFields = changedFields.add("otherLabel");
            return this;
        }

        public TypedEmailAddress build() {
            TypedEmailAddress _x = new TypedEmailAddress();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.typedEmailAddress";
            _x.name = name;
            _x.address = address;
            _x.type = type;
            _x.otherLabel = otherLabel;
            return _x;
        }
    }

    private TypedEmailAddress _copy() {
        TypedEmailAddress _x = new TypedEmailAddress();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.address = address;
        _x.type = type;
        _x.otherLabel = otherLabel;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TypedEmailAddress[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("otherLabel=");
        b.append(this.otherLabel);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
