package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.Tone;

@JsonPropertyOrder({
    "@odata.type", 
    "sequenceId", 
    "tone"})
@JsonInclude(Include.NON_NULL)
public class ToneInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("sequenceId")
    protected Long sequenceId;

    @JsonProperty("tone")
    protected Tone tone;

    protected ToneInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.toneInfo";
    }

    @Property(name="sequenceId")
    @JsonIgnore
    public Optional<Long> getSequenceId() {
        return Optional.ofNullable(sequenceId);
    }

    public ToneInfo withSequenceId(Long sequenceId) {
        ToneInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.toneInfo");
        _x.sequenceId = sequenceId;
        return _x;
    }

    @Property(name="tone")
    @JsonIgnore
    public Optional<Tone> getTone() {
        return Optional.ofNullable(tone);
    }

    public ToneInfo withTone(Tone tone) {
        ToneInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.toneInfo");
        _x.tone = tone;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long sequenceId;
        private Tone tone;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder sequenceId(Long sequenceId) {
            this.sequenceId = sequenceId;
            this.changedFields = changedFields.add("sequenceId");
            return this;
        }

        public Builder tone(Tone tone) {
            this.tone = tone;
            this.changedFields = changedFields.add("tone");
            return this;
        }

        public ToneInfo build() {
            ToneInfo _x = new ToneInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.toneInfo";
            _x.sequenceId = sequenceId;
            _x.tone = tone;
            return _x;
        }
    }

    private ToneInfo _copy() {
        ToneInfo _x = new ToneInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.sequenceId = sequenceId;
        _x.tone = tone;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ToneInfo[");
        b.append("sequenceId=");
        b.append(this.sequenceId);
        b.append(", ");
        b.append("tone=");
        b.append(this.tone);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
