package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "start", 
    "end"})
@JsonInclude(Include.NON_NULL)
public class TimeSlot implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("start")
    protected DateTimeTimeZone start;

    @JsonProperty("end")
    protected DateTimeTimeZone end;

    protected TimeSlot() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeSlot";
    }

    @Property(name="start")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getStart() {
        return Optional.ofNullable(start);
    }

    public TimeSlot withStart(DateTimeTimeZone start) {
        TimeSlot _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeSlot");
        _x.start = start;
        return _x;
    }

    @Property(name="end")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getEnd() {
        return Optional.ofNullable(end);
    }

    public TimeSlot withEnd(DateTimeTimeZone end) {
        TimeSlot _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeSlot");
        _x.end = end;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DateTimeTimeZone start;
        private DateTimeTimeZone end;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder start(DateTimeTimeZone start) {
            this.start = start;
            this.changedFields = changedFields.add("start");
            return this;
        }

        public Builder end(DateTimeTimeZone end) {
            this.end = end;
            this.changedFields = changedFields.add("end");
            return this;
        }

        public TimeSlot build() {
            TimeSlot _x = new TimeSlot();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.timeSlot";
            _x.start = start;
            _x.end = end;
            return _x;
        }
    }

    private TimeSlot _copy() {
        TimeSlot _x = new TimeSlot();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.start = start;
        _x.end = end;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeSlot[");
        b.append("start=");
        b.append(this.start);
        b.append(", ");
        b.append("end=");
        b.append(this.end);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
