package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "startTime", 
    "endTime"})
@JsonInclude(Include.NON_NULL)
public class TimeRange implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("startTime")
    protected LocalTime startTime;

    @JsonProperty("endTime")
    protected LocalTime endTime;

    protected TimeRange() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeRange";
    }

    @Property(name="startTime")
    @JsonIgnore
    public Optional<LocalTime> getStartTime() {
        return Optional.ofNullable(startTime);
    }

    public TimeRange withStartTime(LocalTime startTime) {
        TimeRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeRange");
        _x.startTime = startTime;
        return _x;
    }

    @Property(name="endTime")
    @JsonIgnore
    public Optional<LocalTime> getEndTime() {
        return Optional.ofNullable(endTime);
    }

    public TimeRange withEndTime(LocalTime endTime) {
        TimeRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeRange");
        _x.endTime = endTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private LocalTime startTime;
        private LocalTime endTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder startTime(LocalTime startTime) {
            this.startTime = startTime;
            this.changedFields = changedFields.add("startTime");
            return this;
        }

        public Builder endTime(LocalTime endTime) {
            this.endTime = endTime;
            this.changedFields = changedFields.add("endTime");
            return this;
        }

        public TimeRange build() {
            TimeRange _x = new TimeRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.timeRange";
            _x.startTime = startTime;
            _x.endTime = endTime;
            return _x;
        }
    }

    private TimeRange _copy() {
        TimeRange _x = new TimeRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.startTime = startTime;
        _x.endTime = endTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeRange[");
        b.append("startTime=");
        b.append(this.startTime);
        b.append(", ");
        b.append("endTime=");
        b.append(this.endTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
