package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActivityDomain;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "activityDomain", 
    "timeSlots"})
@JsonInclude(Include.NON_NULL)
public class TimeConstraint implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("activityDomain")
    protected ActivityDomain activityDomain;

    @JsonProperty("timeSlots")
    protected List<TimeSlot> timeSlots;

    @JsonProperty("timeSlots@nextLink")
    protected String timeSlotsNextLink;

    protected TimeConstraint() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.timeConstraint";
    }

    @Property(name="activityDomain")
    @JsonIgnore
    public Optional<ActivityDomain> getActivityDomain() {
        return Optional.ofNullable(activityDomain);
    }

    public TimeConstraint withActivityDomain(ActivityDomain activityDomain) {
        TimeConstraint _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.timeConstraint");
        _x.activityDomain = activityDomain;
        return _x;
    }

    @Property(name="timeSlots")
    @JsonIgnore
    public CollectionPage<TimeSlot> getTimeSlots() {
        return new CollectionPage<TimeSlot>(contextPath, TimeSlot.class, timeSlots, Optional.ofNullable(timeSlotsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="timeSlots")
    @JsonIgnore
    public CollectionPage<TimeSlot> getTimeSlots(HttpRequestOptions options) {
        return new CollectionPage<TimeSlot>(contextPath, TimeSlot.class, timeSlots, Optional.ofNullable(timeSlotsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ActivityDomain activityDomain;
        private List<TimeSlot> timeSlots;
        private String timeSlotsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder activityDomain(ActivityDomain activityDomain) {
            this.activityDomain = activityDomain;
            this.changedFields = changedFields.add("activityDomain");
            return this;
        }

        public Builder timeSlots(List<TimeSlot> timeSlots) {
            this.timeSlots = timeSlots;
            this.changedFields = changedFields.add("timeSlots");
            return this;
        }

        public Builder timeSlots(TimeSlot... timeSlots) {
            return timeSlots(Arrays.asList(timeSlots));
        }

        public Builder timeSlotsNextLink(String timeSlotsNextLink) {
            this.timeSlotsNextLink = timeSlotsNextLink;
            this.changedFields = changedFields.add("timeSlots");
            return this;
        }

        public TimeConstraint build() {
            TimeConstraint _x = new TimeConstraint();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.timeConstraint";
            _x.activityDomain = activityDomain;
            _x.timeSlots = timeSlots;
            _x.timeSlotsNextLink = timeSlotsNextLink;
            return _x;
        }
    }

    private TimeConstraint _copy() {
        TimeConstraint _x = new TimeConstraint();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.activityDomain = activityDomain;
        _x.timeSlots = timeSlots;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeConstraint[");
        b.append("activityDomain=");
        b.append(this.activityDomain);
        b.append(", ");
        b.append("timeSlots=");
        b.append(this.timeSlots);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
