package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "pivotValue", 
    "count"})
@JsonInclude(Include.NON_NULL)
public class ThreatAssessmentRequestsCount implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("pivotValue")
    protected String pivotValue;

    @JsonProperty("count")
    protected Long count;

    protected ThreatAssessmentRequestsCount() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.threatAssessmentRequestsCount";
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ThreatAssessmentRequestsCount withCreatedDateTime(OffsetDateTime createdDateTime) {
        ThreatAssessmentRequestsCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentRequestsCount");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="pivotValue")
    @JsonIgnore
    public Optional<String> getPivotValue() {
        return Optional.ofNullable(pivotValue);
    }

    public ThreatAssessmentRequestsCount withPivotValue(String pivotValue) {
        ThreatAssessmentRequestsCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentRequestsCount");
        _x.pivotValue = pivotValue;
        return _x;
    }

    @Property(name="count")
    @JsonIgnore
    public Optional<Long> getCount() {
        return Optional.ofNullable(count);
    }

    public ThreatAssessmentRequestsCount withCount(Long count) {
        ThreatAssessmentRequestsCount _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.threatAssessmentRequestsCount");
        _x.count = count;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime createdDateTime;
        private String pivotValue;
        private Long count;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder pivotValue(String pivotValue) {
            this.pivotValue = pivotValue;
            this.changedFields = changedFields.add("pivotValue");
            return this;
        }

        public Builder count(Long count) {
            this.count = count;
            this.changedFields = changedFields.add("count");
            return this;
        }

        public ThreatAssessmentRequestsCount build() {
            ThreatAssessmentRequestsCount _x = new ThreatAssessmentRequestsCount();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.threatAssessmentRequestsCount";
            _x.createdDateTime = createdDateTime;
            _x.pivotValue = pivotValue;
            _x.count = count;
            return _x;
        }
    }

    private ThreatAssessmentRequestsCount _copy() {
        ThreatAssessmentRequestsCount _x = new ThreatAssessmentRequestsCount();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.createdDateTime = createdDateTime;
        _x.pivotValue = pivotValue;
        _x.count = count;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ThreatAssessmentRequestsCount[");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("pivotValue=");
        b.append(this.pivotValue);
        b.append(", ");
        b.append("count=");
        b.append(this.count);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
