package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowMultipleLines", 
    "appendChangesToExistingText", 
    "linesForEditing", 
    "maxLength", 
    "textType"})
@JsonInclude(Include.NON_NULL)
public class TextColumn implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowMultipleLines")
    protected Boolean allowMultipleLines;

    @JsonProperty("appendChangesToExistingText")
    protected Boolean appendChangesToExistingText;

    @JsonProperty("linesForEditing")
    protected Integer linesForEditing;

    @JsonProperty("maxLength")
    protected Integer maxLength;

    @JsonProperty("textType")
    protected String textType;

    protected TextColumn() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.textColumn";
    }

    @Property(name="allowMultipleLines")
    @JsonIgnore
    public Optional<Boolean> getAllowMultipleLines() {
        return Optional.ofNullable(allowMultipleLines);
    }

    public TextColumn withAllowMultipleLines(Boolean allowMultipleLines) {
        TextColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.textColumn");
        _x.allowMultipleLines = allowMultipleLines;
        return _x;
    }

    @Property(name="appendChangesToExistingText")
    @JsonIgnore
    public Optional<Boolean> getAppendChangesToExistingText() {
        return Optional.ofNullable(appendChangesToExistingText);
    }

    public TextColumn withAppendChangesToExistingText(Boolean appendChangesToExistingText) {
        TextColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.textColumn");
        _x.appendChangesToExistingText = appendChangesToExistingText;
        return _x;
    }

    @Property(name="linesForEditing")
    @JsonIgnore
    public Optional<Integer> getLinesForEditing() {
        return Optional.ofNullable(linesForEditing);
    }

    public TextColumn withLinesForEditing(Integer linesForEditing) {
        TextColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.textColumn");
        _x.linesForEditing = linesForEditing;
        return _x;
    }

    @Property(name="maxLength")
    @JsonIgnore
    public Optional<Integer> getMaxLength() {
        return Optional.ofNullable(maxLength);
    }

    public TextColumn withMaxLength(Integer maxLength) {
        TextColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.textColumn");
        _x.maxLength = maxLength;
        return _x;
    }

    @Property(name="textType")
    @JsonIgnore
    public Optional<String> getTextType() {
        return Optional.ofNullable(textType);
    }

    public TextColumn withTextType(String textType) {
        TextColumn _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.textColumn");
        _x.textType = textType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowMultipleLines;
        private Boolean appendChangesToExistingText;
        private Integer linesForEditing;
        private Integer maxLength;
        private String textType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder allowMultipleLines(Boolean allowMultipleLines) {
            this.allowMultipleLines = allowMultipleLines;
            this.changedFields = changedFields.add("allowMultipleLines");
            return this;
        }

        public Builder appendChangesToExistingText(Boolean appendChangesToExistingText) {
            this.appendChangesToExistingText = appendChangesToExistingText;
            this.changedFields = changedFields.add("appendChangesToExistingText");
            return this;
        }

        public Builder linesForEditing(Integer linesForEditing) {
            this.linesForEditing = linesForEditing;
            this.changedFields = changedFields.add("linesForEditing");
            return this;
        }

        public Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            this.changedFields = changedFields.add("maxLength");
            return this;
        }

        public Builder textType(String textType) {
            this.textType = textType;
            this.changedFields = changedFields.add("textType");
            return this;
        }

        public TextColumn build() {
            TextColumn _x = new TextColumn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.textColumn";
            _x.allowMultipleLines = allowMultipleLines;
            _x.appendChangesToExistingText = appendChangesToExistingText;
            _x.linesForEditing = linesForEditing;
            _x.maxLength = maxLength;
            _x.textType = textType;
            return _x;
        }
    }

    private TextColumn _copy() {
        TextColumn _x = new TextColumn();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.allowMultipleLines = allowMultipleLines;
        _x.appendChangesToExistingText = appendChangesToExistingText;
        _x.linesForEditing = linesForEditing;
        _x.maxLength = maxLength;
        _x.textType = textType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TextColumn[");
        b.append("allowMultipleLines=");
        b.append(this.allowMultipleLines);
        b.append(", ");
        b.append("appendChangesToExistingText=");
        b.append(this.appendChangesToExistingText);
        b.append(", ");
        b.append("linesForEditing=");
        b.append(this.linesForEditing);
        b.append(", ");
        b.append("maxLength=");
        b.append(this.maxLength);
        b.append(", ");
        b.append("textType=");
        b.append(this.textType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
