package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "averageInboundFrameRate", 
    "averageOutboundFrameRate", 
    "averageInboundBitRate", 
    "averageOutboundBitRate"})
@JsonInclude(Include.NON_NULL)
public class TeleconferenceDeviceVideoQuality extends TeleconferenceDeviceMediaQuality implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("averageInboundFrameRate")
    protected Double averageInboundFrameRate;

    @JsonProperty("averageOutboundFrameRate")
    protected Double averageOutboundFrameRate;

    @JsonProperty("averageInboundBitRate")
    protected Double averageInboundBitRate;

    @JsonProperty("averageOutboundBitRate")
    protected Double averageOutboundBitRate;

    protected TeleconferenceDeviceVideoQuality() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teleconferenceDeviceVideoQuality";
    }

    @Property(name="averageInboundFrameRate")
    @JsonIgnore
    public Optional<Double> getAverageInboundFrameRate() {
        return Optional.ofNullable(averageInboundFrameRate);
    }

    public TeleconferenceDeviceVideoQuality withAverageInboundFrameRate(Double averageInboundFrameRate) {
        TeleconferenceDeviceVideoQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceVideoQuality");
        _x.averageInboundFrameRate = averageInboundFrameRate;
        return _x;
    }

    @Property(name="averageOutboundFrameRate")
    @JsonIgnore
    public Optional<Double> getAverageOutboundFrameRate() {
        return Optional.ofNullable(averageOutboundFrameRate);
    }

    public TeleconferenceDeviceVideoQuality withAverageOutboundFrameRate(Double averageOutboundFrameRate) {
        TeleconferenceDeviceVideoQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceVideoQuality");
        _x.averageOutboundFrameRate = averageOutboundFrameRate;
        return _x;
    }

    @Property(name="averageInboundBitRate")
    @JsonIgnore
    public Optional<Double> getAverageInboundBitRate() {
        return Optional.ofNullable(averageInboundBitRate);
    }

    public TeleconferenceDeviceVideoQuality withAverageInboundBitRate(Double averageInboundBitRate) {
        TeleconferenceDeviceVideoQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceVideoQuality");
        _x.averageInboundBitRate = averageInboundBitRate;
        return _x;
    }

    @Property(name="averageOutboundBitRate")
    @JsonIgnore
    public Optional<Double> getAverageOutboundBitRate() {
        return Optional.ofNullable(averageOutboundBitRate);
    }

    public TeleconferenceDeviceVideoQuality withAverageOutboundBitRate(Double averageOutboundBitRate) {
        TeleconferenceDeviceVideoQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceVideoQuality");
        _x.averageOutboundBitRate = averageOutboundBitRate;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeleconferenceDeviceVideoQuality() {
        return new Builder();
    }

    public static final class Builder {
        private Integer channelIndex;
        private Duration mediaDuration;
        private Long networkLinkSpeedInBytes;
        private String localIPAddress;
        private Integer localPort;
        private String remoteIPAddress;
        private Integer remotePort;
        private Long inboundPackets;
        private Long outboundPackets;
        private Double averageInboundPacketLossRateInPercentage;
        private Double averageOutboundPacketLossRateInPercentage;
        private Double maximumInboundPacketLossRateInPercentage;
        private Double maximumOutboundPacketLossRateInPercentage;
        private Duration averageInboundRoundTripDelay;
        private Duration averageOutboundRoundTripDelay;
        private Duration maximumInboundRoundTripDelay;
        private Duration maximumOutboundRoundTripDelay;
        private Duration averageInboundJitter;
        private Duration averageOutboundJitter;
        private Duration maximumInboundJitter;
        private Duration maximumOutboundJitter;
        private Double averageInboundFrameRate;
        private Double averageOutboundFrameRate;
        private Double averageInboundBitRate;
        private Double averageOutboundBitRate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder channelIndex(Integer channelIndex) {
            this.channelIndex = channelIndex;
            this.changedFields = changedFields.add("channelIndex");
            return this;
        }

        public Builder mediaDuration(Duration mediaDuration) {
            this.mediaDuration = mediaDuration;
            this.changedFields = changedFields.add("mediaDuration");
            return this;
        }

        public Builder networkLinkSpeedInBytes(Long networkLinkSpeedInBytes) {
            this.networkLinkSpeedInBytes = networkLinkSpeedInBytes;
            this.changedFields = changedFields.add("networkLinkSpeedInBytes");
            return this;
        }

        public Builder localIPAddress(String localIPAddress) {
            this.localIPAddress = localIPAddress;
            this.changedFields = changedFields.add("localIPAddress");
            return this;
        }

        public Builder localPort(Integer localPort) {
            this.localPort = localPort;
            this.changedFields = changedFields.add("localPort");
            return this;
        }

        public Builder remoteIPAddress(String remoteIPAddress) {
            this.remoteIPAddress = remoteIPAddress;
            this.changedFields = changedFields.add("remoteIPAddress");
            return this;
        }

        public Builder remotePort(Integer remotePort) {
            this.remotePort = remotePort;
            this.changedFields = changedFields.add("remotePort");
            return this;
        }

        public Builder inboundPackets(Long inboundPackets) {
            this.inboundPackets = inboundPackets;
            this.changedFields = changedFields.add("inboundPackets");
            return this;
        }

        public Builder outboundPackets(Long outboundPackets) {
            this.outboundPackets = outboundPackets;
            this.changedFields = changedFields.add("outboundPackets");
            return this;
        }

        public Builder averageInboundPacketLossRateInPercentage(Double averageInboundPacketLossRateInPercentage) {
            this.averageInboundPacketLossRateInPercentage = averageInboundPacketLossRateInPercentage;
            this.changedFields = changedFields.add("averageInboundPacketLossRateInPercentage");
            return this;
        }

        public Builder averageOutboundPacketLossRateInPercentage(Double averageOutboundPacketLossRateInPercentage) {
            this.averageOutboundPacketLossRateInPercentage = averageOutboundPacketLossRateInPercentage;
            this.changedFields = changedFields.add("averageOutboundPacketLossRateInPercentage");
            return this;
        }

        public Builder maximumInboundPacketLossRateInPercentage(Double maximumInboundPacketLossRateInPercentage) {
            this.maximumInboundPacketLossRateInPercentage = maximumInboundPacketLossRateInPercentage;
            this.changedFields = changedFields.add("maximumInboundPacketLossRateInPercentage");
            return this;
        }

        public Builder maximumOutboundPacketLossRateInPercentage(Double maximumOutboundPacketLossRateInPercentage) {
            this.maximumOutboundPacketLossRateInPercentage = maximumOutboundPacketLossRateInPercentage;
            this.changedFields = changedFields.add("maximumOutboundPacketLossRateInPercentage");
            return this;
        }

        public Builder averageInboundRoundTripDelay(Duration averageInboundRoundTripDelay) {
            this.averageInboundRoundTripDelay = averageInboundRoundTripDelay;
            this.changedFields = changedFields.add("averageInboundRoundTripDelay");
            return this;
        }

        public Builder averageOutboundRoundTripDelay(Duration averageOutboundRoundTripDelay) {
            this.averageOutboundRoundTripDelay = averageOutboundRoundTripDelay;
            this.changedFields = changedFields.add("averageOutboundRoundTripDelay");
            return this;
        }

        public Builder maximumInboundRoundTripDelay(Duration maximumInboundRoundTripDelay) {
            this.maximumInboundRoundTripDelay = maximumInboundRoundTripDelay;
            this.changedFields = changedFields.add("maximumInboundRoundTripDelay");
            return this;
        }

        public Builder maximumOutboundRoundTripDelay(Duration maximumOutboundRoundTripDelay) {
            this.maximumOutboundRoundTripDelay = maximumOutboundRoundTripDelay;
            this.changedFields = changedFields.add("maximumOutboundRoundTripDelay");
            return this;
        }

        public Builder averageInboundJitter(Duration averageInboundJitter) {
            this.averageInboundJitter = averageInboundJitter;
            this.changedFields = changedFields.add("averageInboundJitter");
            return this;
        }

        public Builder averageOutboundJitter(Duration averageOutboundJitter) {
            this.averageOutboundJitter = averageOutboundJitter;
            this.changedFields = changedFields.add("averageOutboundJitter");
            return this;
        }

        public Builder maximumInboundJitter(Duration maximumInboundJitter) {
            this.maximumInboundJitter = maximumInboundJitter;
            this.changedFields = changedFields.add("maximumInboundJitter");
            return this;
        }

        public Builder maximumOutboundJitter(Duration maximumOutboundJitter) {
            this.maximumOutboundJitter = maximumOutboundJitter;
            this.changedFields = changedFields.add("maximumOutboundJitter");
            return this;
        }

        public Builder averageInboundFrameRate(Double averageInboundFrameRate) {
            this.averageInboundFrameRate = averageInboundFrameRate;
            this.changedFields = changedFields.add("averageInboundFrameRate");
            return this;
        }

        public Builder averageOutboundFrameRate(Double averageOutboundFrameRate) {
            this.averageOutboundFrameRate = averageOutboundFrameRate;
            this.changedFields = changedFields.add("averageOutboundFrameRate");
            return this;
        }

        public Builder averageInboundBitRate(Double averageInboundBitRate) {
            this.averageInboundBitRate = averageInboundBitRate;
            this.changedFields = changedFields.add("averageInboundBitRate");
            return this;
        }

        public Builder averageOutboundBitRate(Double averageOutboundBitRate) {
            this.averageOutboundBitRate = averageOutboundBitRate;
            this.changedFields = changedFields.add("averageOutboundBitRate");
            return this;
        }

        public TeleconferenceDeviceVideoQuality build() {
            TeleconferenceDeviceVideoQuality _x = new TeleconferenceDeviceVideoQuality();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.teleconferenceDeviceVideoQuality";
            _x.channelIndex = channelIndex;
            _x.mediaDuration = mediaDuration;
            _x.networkLinkSpeedInBytes = networkLinkSpeedInBytes;
            _x.localIPAddress = localIPAddress;
            _x.localPort = localPort;
            _x.remoteIPAddress = remoteIPAddress;
            _x.remotePort = remotePort;
            _x.inboundPackets = inboundPackets;
            _x.outboundPackets = outboundPackets;
            _x.averageInboundPacketLossRateInPercentage = averageInboundPacketLossRateInPercentage;
            _x.averageOutboundPacketLossRateInPercentage = averageOutboundPacketLossRateInPercentage;
            _x.maximumInboundPacketLossRateInPercentage = maximumInboundPacketLossRateInPercentage;
            _x.maximumOutboundPacketLossRateInPercentage = maximumOutboundPacketLossRateInPercentage;
            _x.averageInboundRoundTripDelay = averageInboundRoundTripDelay;
            _x.averageOutboundRoundTripDelay = averageOutboundRoundTripDelay;
            _x.maximumInboundRoundTripDelay = maximumInboundRoundTripDelay;
            _x.maximumOutboundRoundTripDelay = maximumOutboundRoundTripDelay;
            _x.averageInboundJitter = averageInboundJitter;
            _x.averageOutboundJitter = averageOutboundJitter;
            _x.maximumInboundJitter = maximumInboundJitter;
            _x.maximumOutboundJitter = maximumOutboundJitter;
            _x.averageInboundFrameRate = averageInboundFrameRate;
            _x.averageOutboundFrameRate = averageOutboundFrameRate;
            _x.averageInboundBitRate = averageInboundBitRate;
            _x.averageOutboundBitRate = averageOutboundBitRate;
            return _x;
        }
    }

    private TeleconferenceDeviceVideoQuality _copy() {
        TeleconferenceDeviceVideoQuality _x = new TeleconferenceDeviceVideoQuality();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.channelIndex = channelIndex;
        _x.mediaDuration = mediaDuration;
        _x.networkLinkSpeedInBytes = networkLinkSpeedInBytes;
        _x.localIPAddress = localIPAddress;
        _x.localPort = localPort;
        _x.remoteIPAddress = remoteIPAddress;
        _x.remotePort = remotePort;
        _x.inboundPackets = inboundPackets;
        _x.outboundPackets = outboundPackets;
        _x.averageInboundPacketLossRateInPercentage = averageInboundPacketLossRateInPercentage;
        _x.averageOutboundPacketLossRateInPercentage = averageOutboundPacketLossRateInPercentage;
        _x.maximumInboundPacketLossRateInPercentage = maximumInboundPacketLossRateInPercentage;
        _x.maximumOutboundPacketLossRateInPercentage = maximumOutboundPacketLossRateInPercentage;
        _x.averageInboundRoundTripDelay = averageInboundRoundTripDelay;
        _x.averageOutboundRoundTripDelay = averageOutboundRoundTripDelay;
        _x.maximumInboundRoundTripDelay = maximumInboundRoundTripDelay;
        _x.maximumOutboundRoundTripDelay = maximumOutboundRoundTripDelay;
        _x.averageInboundJitter = averageInboundJitter;
        _x.averageOutboundJitter = averageOutboundJitter;
        _x.maximumInboundJitter = maximumInboundJitter;
        _x.maximumOutboundJitter = maximumOutboundJitter;
        _x.averageInboundFrameRate = averageInboundFrameRate;
        _x.averageOutboundFrameRate = averageOutboundFrameRate;
        _x.averageInboundBitRate = averageInboundBitRate;
        _x.averageOutboundBitRate = averageOutboundBitRate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeleconferenceDeviceVideoQuality[");
        b.append("channelIndex=");
        b.append(this.channelIndex);
        b.append(", ");
        b.append("mediaDuration=");
        b.append(this.mediaDuration);
        b.append(", ");
        b.append("networkLinkSpeedInBytes=");
        b.append(this.networkLinkSpeedInBytes);
        b.append(", ");
        b.append("localIPAddress=");
        b.append(this.localIPAddress);
        b.append(", ");
        b.append("localPort=");
        b.append(this.localPort);
        b.append(", ");
        b.append("remoteIPAddress=");
        b.append(this.remoteIPAddress);
        b.append(", ");
        b.append("remotePort=");
        b.append(this.remotePort);
        b.append(", ");
        b.append("inboundPackets=");
        b.append(this.inboundPackets);
        b.append(", ");
        b.append("outboundPackets=");
        b.append(this.outboundPackets);
        b.append(", ");
        b.append("averageInboundPacketLossRateInPercentage=");
        b.append(this.averageInboundPacketLossRateInPercentage);
        b.append(", ");
        b.append("averageOutboundPacketLossRateInPercentage=");
        b.append(this.averageOutboundPacketLossRateInPercentage);
        b.append(", ");
        b.append("maximumInboundPacketLossRateInPercentage=");
        b.append(this.maximumInboundPacketLossRateInPercentage);
        b.append(", ");
        b.append("maximumOutboundPacketLossRateInPercentage=");
        b.append(this.maximumOutboundPacketLossRateInPercentage);
        b.append(", ");
        b.append("averageInboundRoundTripDelay=");
        b.append(this.averageInboundRoundTripDelay);
        b.append(", ");
        b.append("averageOutboundRoundTripDelay=");
        b.append(this.averageOutboundRoundTripDelay);
        b.append(", ");
        b.append("maximumInboundRoundTripDelay=");
        b.append(this.maximumInboundRoundTripDelay);
        b.append(", ");
        b.append("maximumOutboundRoundTripDelay=");
        b.append(this.maximumOutboundRoundTripDelay);
        b.append(", ");
        b.append("averageInboundJitter=");
        b.append(this.averageInboundJitter);
        b.append(", ");
        b.append("averageOutboundJitter=");
        b.append(this.averageOutboundJitter);
        b.append(", ");
        b.append("maximumInboundJitter=");
        b.append(this.maximumInboundJitter);
        b.append(", ");
        b.append("maximumOutboundJitter=");
        b.append(this.maximumOutboundJitter);
        b.append(", ");
        b.append("averageInboundFrameRate=");
        b.append(this.averageInboundFrameRate);
        b.append(", ");
        b.append("averageOutboundFrameRate=");
        b.append(this.averageOutboundFrameRate);
        b.append(", ");
        b.append("averageInboundBitRate=");
        b.append(this.averageInboundBitRate);
        b.append(", ");
        b.append("averageOutboundBitRate=");
        b.append(this.averageOutboundBitRate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
