package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "channelIndex", 
    "mediaDuration", 
    "networkLinkSpeedInBytes", 
    "localIPAddress", 
    "localPort", 
    "remoteIPAddress", 
    "remotePort", 
    "inboundPackets", 
    "outboundPackets", 
    "averageInboundPacketLossRateInPercentage", 
    "averageOutboundPacketLossRateInPercentage", 
    "maximumInboundPacketLossRateInPercentage", 
    "maximumOutboundPacketLossRateInPercentage", 
    "averageInboundRoundTripDelay", 
    "averageOutboundRoundTripDelay", 
    "maximumInboundRoundTripDelay", 
    "maximumOutboundRoundTripDelay", 
    "averageInboundJitter", 
    "averageOutboundJitter", 
    "maximumInboundJitter", 
    "maximumOutboundJitter"})
@JsonInclude(Include.NON_NULL)
public class TeleconferenceDeviceMediaQuality implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("channelIndex")
    protected Integer channelIndex;

    @JsonProperty("mediaDuration")
    protected Duration mediaDuration;

    @JsonProperty("networkLinkSpeedInBytes")
    protected Long networkLinkSpeedInBytes;

    @JsonProperty("localIPAddress")
    protected String localIPAddress;

    @JsonProperty("localPort")
    protected Integer localPort;

    @JsonProperty("remoteIPAddress")
    protected String remoteIPAddress;

    @JsonProperty("remotePort")
    protected Integer remotePort;

    @JsonProperty("inboundPackets")
    protected Long inboundPackets;

    @JsonProperty("outboundPackets")
    protected Long outboundPackets;

    @JsonProperty("averageInboundPacketLossRateInPercentage")
    protected Double averageInboundPacketLossRateInPercentage;

    @JsonProperty("averageOutboundPacketLossRateInPercentage")
    protected Double averageOutboundPacketLossRateInPercentage;

    @JsonProperty("maximumInboundPacketLossRateInPercentage")
    protected Double maximumInboundPacketLossRateInPercentage;

    @JsonProperty("maximumOutboundPacketLossRateInPercentage")
    protected Double maximumOutboundPacketLossRateInPercentage;

    @JsonProperty("averageInboundRoundTripDelay")
    protected Duration averageInboundRoundTripDelay;

    @JsonProperty("averageOutboundRoundTripDelay")
    protected Duration averageOutboundRoundTripDelay;

    @JsonProperty("maximumInboundRoundTripDelay")
    protected Duration maximumInboundRoundTripDelay;

    @JsonProperty("maximumOutboundRoundTripDelay")
    protected Duration maximumOutboundRoundTripDelay;

    @JsonProperty("averageInboundJitter")
    protected Duration averageInboundJitter;

    @JsonProperty("averageOutboundJitter")
    protected Duration averageOutboundJitter;

    @JsonProperty("maximumInboundJitter")
    protected Duration maximumInboundJitter;

    @JsonProperty("maximumOutboundJitter")
    protected Duration maximumOutboundJitter;

    protected TeleconferenceDeviceMediaQuality() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teleconferenceDeviceMediaQuality";
    }

    @Property(name="channelIndex")
    @JsonIgnore
    public Optional<Integer> getChannelIndex() {
        return Optional.ofNullable(channelIndex);
    }

    public TeleconferenceDeviceMediaQuality withChannelIndex(Integer channelIndex) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.channelIndex = channelIndex;
        return _x;
    }

    @Property(name="mediaDuration")
    @JsonIgnore
    public Optional<Duration> getMediaDuration() {
        return Optional.ofNullable(mediaDuration);
    }

    public TeleconferenceDeviceMediaQuality withMediaDuration(Duration mediaDuration) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.mediaDuration = mediaDuration;
        return _x;
    }

    @Property(name="networkLinkSpeedInBytes")
    @JsonIgnore
    public Optional<Long> getNetworkLinkSpeedInBytes() {
        return Optional.ofNullable(networkLinkSpeedInBytes);
    }

    public TeleconferenceDeviceMediaQuality withNetworkLinkSpeedInBytes(Long networkLinkSpeedInBytes) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.networkLinkSpeedInBytes = networkLinkSpeedInBytes;
        return _x;
    }

    @Property(name="localIPAddress")
    @JsonIgnore
    public Optional<String> getLocalIPAddress() {
        return Optional.ofNullable(localIPAddress);
    }

    public TeleconferenceDeviceMediaQuality withLocalIPAddress(String localIPAddress) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.localIPAddress = localIPAddress;
        return _x;
    }

    @Property(name="localPort")
    @JsonIgnore
    public Optional<Integer> getLocalPort() {
        return Optional.ofNullable(localPort);
    }

    public TeleconferenceDeviceMediaQuality withLocalPort(Integer localPort) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.localPort = localPort;
        return _x;
    }

    @Property(name="remoteIPAddress")
    @JsonIgnore
    public Optional<String> getRemoteIPAddress() {
        return Optional.ofNullable(remoteIPAddress);
    }

    public TeleconferenceDeviceMediaQuality withRemoteIPAddress(String remoteIPAddress) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.remoteIPAddress = remoteIPAddress;
        return _x;
    }

    @Property(name="remotePort")
    @JsonIgnore
    public Optional<Integer> getRemotePort() {
        return Optional.ofNullable(remotePort);
    }

    public TeleconferenceDeviceMediaQuality withRemotePort(Integer remotePort) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.remotePort = remotePort;
        return _x;
    }

    @Property(name="inboundPackets")
    @JsonIgnore
    public Optional<Long> getInboundPackets() {
        return Optional.ofNullable(inboundPackets);
    }

    public TeleconferenceDeviceMediaQuality withInboundPackets(Long inboundPackets) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.inboundPackets = inboundPackets;
        return _x;
    }

    @Property(name="outboundPackets")
    @JsonIgnore
    public Optional<Long> getOutboundPackets() {
        return Optional.ofNullable(outboundPackets);
    }

    public TeleconferenceDeviceMediaQuality withOutboundPackets(Long outboundPackets) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.outboundPackets = outboundPackets;
        return _x;
    }

    @Property(name="averageInboundPacketLossRateInPercentage")
    @JsonIgnore
    public Optional<Double> getAverageInboundPacketLossRateInPercentage() {
        return Optional.ofNullable(averageInboundPacketLossRateInPercentage);
    }

    public TeleconferenceDeviceMediaQuality withAverageInboundPacketLossRateInPercentage(Double averageInboundPacketLossRateInPercentage) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.averageInboundPacketLossRateInPercentage = averageInboundPacketLossRateInPercentage;
        return _x;
    }

    @Property(name="averageOutboundPacketLossRateInPercentage")
    @JsonIgnore
    public Optional<Double> getAverageOutboundPacketLossRateInPercentage() {
        return Optional.ofNullable(averageOutboundPacketLossRateInPercentage);
    }

    public TeleconferenceDeviceMediaQuality withAverageOutboundPacketLossRateInPercentage(Double averageOutboundPacketLossRateInPercentage) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.averageOutboundPacketLossRateInPercentage = averageOutboundPacketLossRateInPercentage;
        return _x;
    }

    @Property(name="maximumInboundPacketLossRateInPercentage")
    @JsonIgnore
    public Optional<Double> getMaximumInboundPacketLossRateInPercentage() {
        return Optional.ofNullable(maximumInboundPacketLossRateInPercentage);
    }

    public TeleconferenceDeviceMediaQuality withMaximumInboundPacketLossRateInPercentage(Double maximumInboundPacketLossRateInPercentage) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.maximumInboundPacketLossRateInPercentage = maximumInboundPacketLossRateInPercentage;
        return _x;
    }

    @Property(name="maximumOutboundPacketLossRateInPercentage")
    @JsonIgnore
    public Optional<Double> getMaximumOutboundPacketLossRateInPercentage() {
        return Optional.ofNullable(maximumOutboundPacketLossRateInPercentage);
    }

    public TeleconferenceDeviceMediaQuality withMaximumOutboundPacketLossRateInPercentage(Double maximumOutboundPacketLossRateInPercentage) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.maximumOutboundPacketLossRateInPercentage = maximumOutboundPacketLossRateInPercentage;
        return _x;
    }

    @Property(name="averageInboundRoundTripDelay")
    @JsonIgnore
    public Optional<Duration> getAverageInboundRoundTripDelay() {
        return Optional.ofNullable(averageInboundRoundTripDelay);
    }

    public TeleconferenceDeviceMediaQuality withAverageInboundRoundTripDelay(Duration averageInboundRoundTripDelay) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.averageInboundRoundTripDelay = averageInboundRoundTripDelay;
        return _x;
    }

    @Property(name="averageOutboundRoundTripDelay")
    @JsonIgnore
    public Optional<Duration> getAverageOutboundRoundTripDelay() {
        return Optional.ofNullable(averageOutboundRoundTripDelay);
    }

    public TeleconferenceDeviceMediaQuality withAverageOutboundRoundTripDelay(Duration averageOutboundRoundTripDelay) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.averageOutboundRoundTripDelay = averageOutboundRoundTripDelay;
        return _x;
    }

    @Property(name="maximumInboundRoundTripDelay")
    @JsonIgnore
    public Optional<Duration> getMaximumInboundRoundTripDelay() {
        return Optional.ofNullable(maximumInboundRoundTripDelay);
    }

    public TeleconferenceDeviceMediaQuality withMaximumInboundRoundTripDelay(Duration maximumInboundRoundTripDelay) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.maximumInboundRoundTripDelay = maximumInboundRoundTripDelay;
        return _x;
    }

    @Property(name="maximumOutboundRoundTripDelay")
    @JsonIgnore
    public Optional<Duration> getMaximumOutboundRoundTripDelay() {
        return Optional.ofNullable(maximumOutboundRoundTripDelay);
    }

    public TeleconferenceDeviceMediaQuality withMaximumOutboundRoundTripDelay(Duration maximumOutboundRoundTripDelay) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.maximumOutboundRoundTripDelay = maximumOutboundRoundTripDelay;
        return _x;
    }

    @Property(name="averageInboundJitter")
    @JsonIgnore
    public Optional<Duration> getAverageInboundJitter() {
        return Optional.ofNullable(averageInboundJitter);
    }

    public TeleconferenceDeviceMediaQuality withAverageInboundJitter(Duration averageInboundJitter) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.averageInboundJitter = averageInboundJitter;
        return _x;
    }

    @Property(name="averageOutboundJitter")
    @JsonIgnore
    public Optional<Duration> getAverageOutboundJitter() {
        return Optional.ofNullable(averageOutboundJitter);
    }

    public TeleconferenceDeviceMediaQuality withAverageOutboundJitter(Duration averageOutboundJitter) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.averageOutboundJitter = averageOutboundJitter;
        return _x;
    }

    @Property(name="maximumInboundJitter")
    @JsonIgnore
    public Optional<Duration> getMaximumInboundJitter() {
        return Optional.ofNullable(maximumInboundJitter);
    }

    public TeleconferenceDeviceMediaQuality withMaximumInboundJitter(Duration maximumInboundJitter) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.maximumInboundJitter = maximumInboundJitter;
        return _x;
    }

    @Property(name="maximumOutboundJitter")
    @JsonIgnore
    public Optional<Duration> getMaximumOutboundJitter() {
        return Optional.ofNullable(maximumOutboundJitter);
    }

    public TeleconferenceDeviceMediaQuality withMaximumOutboundJitter(Duration maximumOutboundJitter) {
        TeleconferenceDeviceMediaQuality _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teleconferenceDeviceMediaQuality");
        _x.maximumOutboundJitter = maximumOutboundJitter;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private TeleconferenceDeviceMediaQuality _copy() {
        TeleconferenceDeviceMediaQuality _x = new TeleconferenceDeviceMediaQuality();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.channelIndex = channelIndex;
        _x.mediaDuration = mediaDuration;
        _x.networkLinkSpeedInBytes = networkLinkSpeedInBytes;
        _x.localIPAddress = localIPAddress;
        _x.localPort = localPort;
        _x.remoteIPAddress = remoteIPAddress;
        _x.remotePort = remotePort;
        _x.inboundPackets = inboundPackets;
        _x.outboundPackets = outboundPackets;
        _x.averageInboundPacketLossRateInPercentage = averageInboundPacketLossRateInPercentage;
        _x.averageOutboundPacketLossRateInPercentage = averageOutboundPacketLossRateInPercentage;
        _x.maximumInboundPacketLossRateInPercentage = maximumInboundPacketLossRateInPercentage;
        _x.maximumOutboundPacketLossRateInPercentage = maximumOutboundPacketLossRateInPercentage;
        _x.averageInboundRoundTripDelay = averageInboundRoundTripDelay;
        _x.averageOutboundRoundTripDelay = averageOutboundRoundTripDelay;
        _x.maximumInboundRoundTripDelay = maximumInboundRoundTripDelay;
        _x.maximumOutboundRoundTripDelay = maximumOutboundRoundTripDelay;
        _x.averageInboundJitter = averageInboundJitter;
        _x.averageOutboundJitter = averageOutboundJitter;
        _x.maximumInboundJitter = maximumInboundJitter;
        _x.maximumOutboundJitter = maximumOutboundJitter;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeleconferenceDeviceMediaQuality[");
        b.append("channelIndex=");
        b.append(this.channelIndex);
        b.append(", ");
        b.append("mediaDuration=");
        b.append(this.mediaDuration);
        b.append(", ");
        b.append("networkLinkSpeedInBytes=");
        b.append(this.networkLinkSpeedInBytes);
        b.append(", ");
        b.append("localIPAddress=");
        b.append(this.localIPAddress);
        b.append(", ");
        b.append("localPort=");
        b.append(this.localPort);
        b.append(", ");
        b.append("remoteIPAddress=");
        b.append(this.remoteIPAddress);
        b.append(", ");
        b.append("remotePort=");
        b.append(this.remotePort);
        b.append(", ");
        b.append("inboundPackets=");
        b.append(this.inboundPackets);
        b.append(", ");
        b.append("outboundPackets=");
        b.append(this.outboundPackets);
        b.append(", ");
        b.append("averageInboundPacketLossRateInPercentage=");
        b.append(this.averageInboundPacketLossRateInPercentage);
        b.append(", ");
        b.append("averageOutboundPacketLossRateInPercentage=");
        b.append(this.averageOutboundPacketLossRateInPercentage);
        b.append(", ");
        b.append("maximumInboundPacketLossRateInPercentage=");
        b.append(this.maximumInboundPacketLossRateInPercentage);
        b.append(", ");
        b.append("maximumOutboundPacketLossRateInPercentage=");
        b.append(this.maximumOutboundPacketLossRateInPercentage);
        b.append(", ");
        b.append("averageInboundRoundTripDelay=");
        b.append(this.averageInboundRoundTripDelay);
        b.append(", ");
        b.append("averageOutboundRoundTripDelay=");
        b.append(this.averageOutboundRoundTripDelay);
        b.append(", ");
        b.append("maximumInboundRoundTripDelay=");
        b.append(this.maximumInboundRoundTripDelay);
        b.append(", ");
        b.append("maximumOutboundRoundTripDelay=");
        b.append(this.maximumOutboundRoundTripDelay);
        b.append(", ");
        b.append("averageInboundJitter=");
        b.append(this.averageInboundJitter);
        b.append(", ");
        b.append("averageOutboundJitter=");
        b.append(this.averageOutboundJitter);
        b.append(", ");
        b.append("maximumInboundJitter=");
        b.append(this.maximumInboundJitter);
        b.append(", ");
        b.append("maximumOutboundJitter=");
        b.append(this.maximumOutboundJitter);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
