package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "entityId", 
    "contentUrl", 
    "removeUrl", 
    "websiteUrl"})
@JsonInclude(Include.NON_NULL)
public class TeamsTabConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("entityId")
    protected String entityId;

    @JsonProperty("contentUrl")
    protected String contentUrl;

    @JsonProperty("removeUrl")
    protected String removeUrl;

    @JsonProperty("websiteUrl")
    protected String websiteUrl;

    protected TeamsTabConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamsTabConfiguration";
    }

    @Property(name="entityId")
    @JsonIgnore
    public Optional<String> getEntityId() {
        return Optional.ofNullable(entityId);
    }

    public TeamsTabConfiguration withEntityId(String entityId) {
        TeamsTabConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsTabConfiguration");
        _x.entityId = entityId;
        return _x;
    }

    @Property(name="contentUrl")
    @JsonIgnore
    public Optional<String> getContentUrl() {
        return Optional.ofNullable(contentUrl);
    }

    public TeamsTabConfiguration withContentUrl(String contentUrl) {
        TeamsTabConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsTabConfiguration");
        _x.contentUrl = contentUrl;
        return _x;
    }

    @Property(name="removeUrl")
    @JsonIgnore
    public Optional<String> getRemoveUrl() {
        return Optional.ofNullable(removeUrl);
    }

    public TeamsTabConfiguration withRemoveUrl(String removeUrl) {
        TeamsTabConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsTabConfiguration");
        _x.removeUrl = removeUrl;
        return _x;
    }

    @Property(name="websiteUrl")
    @JsonIgnore
    public Optional<String> getWebsiteUrl() {
        return Optional.ofNullable(websiteUrl);
    }

    public TeamsTabConfiguration withWebsiteUrl(String websiteUrl) {
        TeamsTabConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamsTabConfiguration");
        _x.websiteUrl = websiteUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String entityId;
        private String contentUrl;
        private String removeUrl;
        private String websiteUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.changedFields = changedFields.add("entityId");
            return this;
        }

        public Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            this.changedFields = changedFields.add("contentUrl");
            return this;
        }

        public Builder removeUrl(String removeUrl) {
            this.removeUrl = removeUrl;
            this.changedFields = changedFields.add("removeUrl");
            return this;
        }

        public Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            this.changedFields = changedFields.add("websiteUrl");
            return this;
        }

        public TeamsTabConfiguration build() {
            TeamsTabConfiguration _x = new TeamsTabConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.teamsTabConfiguration";
            _x.entityId = entityId;
            _x.contentUrl = contentUrl;
            _x.removeUrl = removeUrl;
            _x.websiteUrl = websiteUrl;
            return _x;
        }
    }

    private TeamsTabConfiguration _copy() {
        TeamsTabConfiguration _x = new TeamsTabConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.entityId = entityId;
        _x.contentUrl = contentUrl;
        _x.removeUrl = removeUrl;
        _x.websiteUrl = websiteUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamsTabConfiguration[");
        b.append("entityId=");
        b.append(this.entityId);
        b.append(", ");
        b.append("contentUrl=");
        b.append(this.contentUrl);
        b.append(", ");
        b.append("removeUrl=");
        b.append(this.removeUrl);
        b.append(", ");
        b.append("websiteUrl=");
        b.append(this.websiteUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
