package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "allowCreateUpdateChannels", 
    "allowCreatePrivateChannels", 
    "allowDeleteChannels", 
    "allowAddRemoveApps", 
    "allowCreateUpdateRemoveTabs", 
    "allowCreateUpdateRemoveConnectors"})
@JsonInclude(Include.NON_NULL)
public class TeamMemberSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowCreateUpdateChannels")
    protected Boolean allowCreateUpdateChannels;

    @JsonProperty("allowCreatePrivateChannels")
    protected Boolean allowCreatePrivateChannels;

    @JsonProperty("allowDeleteChannels")
    protected Boolean allowDeleteChannels;

    @JsonProperty("allowAddRemoveApps")
    protected Boolean allowAddRemoveApps;

    @JsonProperty("allowCreateUpdateRemoveTabs")
    protected Boolean allowCreateUpdateRemoveTabs;

    @JsonProperty("allowCreateUpdateRemoveConnectors")
    protected Boolean allowCreateUpdateRemoveConnectors;

    protected TeamMemberSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamMemberSettings";
    }

    @Property(name="allowCreateUpdateChannels")
    @JsonIgnore
    public Optional<Boolean> getAllowCreateUpdateChannels() {
        return Optional.ofNullable(allowCreateUpdateChannels);
    }

    public TeamMemberSettings withAllowCreateUpdateChannels(Boolean allowCreateUpdateChannels) {
        TeamMemberSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamMemberSettings");
        _x.allowCreateUpdateChannels = allowCreateUpdateChannels;
        return _x;
    }

    @Property(name="allowCreatePrivateChannels")
    @JsonIgnore
    public Optional<Boolean> getAllowCreatePrivateChannels() {
        return Optional.ofNullable(allowCreatePrivateChannels);
    }

    public TeamMemberSettings withAllowCreatePrivateChannels(Boolean allowCreatePrivateChannels) {
        TeamMemberSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamMemberSettings");
        _x.allowCreatePrivateChannels = allowCreatePrivateChannels;
        return _x;
    }

    @Property(name="allowDeleteChannels")
    @JsonIgnore
    public Optional<Boolean> getAllowDeleteChannels() {
        return Optional.ofNullable(allowDeleteChannels);
    }

    public TeamMemberSettings withAllowDeleteChannels(Boolean allowDeleteChannels) {
        TeamMemberSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamMemberSettings");
        _x.allowDeleteChannels = allowDeleteChannels;
        return _x;
    }

    @Property(name="allowAddRemoveApps")
    @JsonIgnore
    public Optional<Boolean> getAllowAddRemoveApps() {
        return Optional.ofNullable(allowAddRemoveApps);
    }

    public TeamMemberSettings withAllowAddRemoveApps(Boolean allowAddRemoveApps) {
        TeamMemberSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamMemberSettings");
        _x.allowAddRemoveApps = allowAddRemoveApps;
        return _x;
    }

    @Property(name="allowCreateUpdateRemoveTabs")
    @JsonIgnore
    public Optional<Boolean> getAllowCreateUpdateRemoveTabs() {
        return Optional.ofNullable(allowCreateUpdateRemoveTabs);
    }

    public TeamMemberSettings withAllowCreateUpdateRemoveTabs(Boolean allowCreateUpdateRemoveTabs) {
        TeamMemberSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamMemberSettings");
        _x.allowCreateUpdateRemoveTabs = allowCreateUpdateRemoveTabs;
        return _x;
    }

    @Property(name="allowCreateUpdateRemoveConnectors")
    @JsonIgnore
    public Optional<Boolean> getAllowCreateUpdateRemoveConnectors() {
        return Optional.ofNullable(allowCreateUpdateRemoveConnectors);
    }

    public TeamMemberSettings withAllowCreateUpdateRemoveConnectors(Boolean allowCreateUpdateRemoveConnectors) {
        TeamMemberSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamMemberSettings");
        _x.allowCreateUpdateRemoveConnectors = allowCreateUpdateRemoveConnectors;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowCreateUpdateChannels;
        private Boolean allowCreatePrivateChannels;
        private Boolean allowDeleteChannels;
        private Boolean allowAddRemoveApps;
        private Boolean allowCreateUpdateRemoveTabs;
        private Boolean allowCreateUpdateRemoveConnectors;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder allowCreateUpdateChannels(Boolean allowCreateUpdateChannels) {
            this.allowCreateUpdateChannels = allowCreateUpdateChannels;
            this.changedFields = changedFields.add("allowCreateUpdateChannels");
            return this;
        }

        public Builder allowCreatePrivateChannels(Boolean allowCreatePrivateChannels) {
            this.allowCreatePrivateChannels = allowCreatePrivateChannels;
            this.changedFields = changedFields.add("allowCreatePrivateChannels");
            return this;
        }

        public Builder allowDeleteChannels(Boolean allowDeleteChannels) {
            this.allowDeleteChannels = allowDeleteChannels;
            this.changedFields = changedFields.add("allowDeleteChannels");
            return this;
        }

        public Builder allowAddRemoveApps(Boolean allowAddRemoveApps) {
            this.allowAddRemoveApps = allowAddRemoveApps;
            this.changedFields = changedFields.add("allowAddRemoveApps");
            return this;
        }

        public Builder allowCreateUpdateRemoveTabs(Boolean allowCreateUpdateRemoveTabs) {
            this.allowCreateUpdateRemoveTabs = allowCreateUpdateRemoveTabs;
            this.changedFields = changedFields.add("allowCreateUpdateRemoveTabs");
            return this;
        }

        public Builder allowCreateUpdateRemoveConnectors(Boolean allowCreateUpdateRemoveConnectors) {
            this.allowCreateUpdateRemoveConnectors = allowCreateUpdateRemoveConnectors;
            this.changedFields = changedFields.add("allowCreateUpdateRemoveConnectors");
            return this;
        }

        public TeamMemberSettings build() {
            TeamMemberSettings _x = new TeamMemberSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.teamMemberSettings";
            _x.allowCreateUpdateChannels = allowCreateUpdateChannels;
            _x.allowCreatePrivateChannels = allowCreatePrivateChannels;
            _x.allowDeleteChannels = allowDeleteChannels;
            _x.allowAddRemoveApps = allowAddRemoveApps;
            _x.allowCreateUpdateRemoveTabs = allowCreateUpdateRemoveTabs;
            _x.allowCreateUpdateRemoveConnectors = allowCreateUpdateRemoveConnectors;
            return _x;
        }
    }

    private TeamMemberSettings _copy() {
        TeamMemberSettings _x = new TeamMemberSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.allowCreateUpdateChannels = allowCreateUpdateChannels;
        _x.allowCreatePrivateChannels = allowCreatePrivateChannels;
        _x.allowDeleteChannels = allowDeleteChannels;
        _x.allowAddRemoveApps = allowAddRemoveApps;
        _x.allowCreateUpdateRemoveTabs = allowCreateUpdateRemoveTabs;
        _x.allowCreateUpdateRemoveConnectors = allowCreateUpdateRemoveConnectors;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamMemberSettings[");
        b.append("allowCreateUpdateChannels=");
        b.append(this.allowCreateUpdateChannels);
        b.append(", ");
        b.append("allowCreatePrivateChannels=");
        b.append(this.allowCreatePrivateChannels);
        b.append(", ");
        b.append("allowDeleteChannels=");
        b.append(this.allowDeleteChannels);
        b.append(", ");
        b.append("allowAddRemoveApps=");
        b.append(this.allowAddRemoveApps);
        b.append(", ");
        b.append("allowCreateUpdateRemoveTabs=");
        b.append(this.allowCreateUpdateRemoveTabs);
        b.append(", ");
        b.append("allowCreateUpdateRemoveConnectors=");
        b.append(this.allowCreateUpdateRemoveConnectors);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
