package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.GiphyRatingType;

@JsonPropertyOrder({
    "@odata.type", 
    "allowGiphy", 
    "giphyContentRating", 
    "allowStickersAndMemes", 
    "allowCustomMemes"})
@JsonInclude(Include.NON_NULL)
public class TeamFunSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("allowGiphy")
    protected Boolean allowGiphy;

    @JsonProperty("giphyContentRating")
    protected GiphyRatingType giphyContentRating;

    @JsonProperty("allowStickersAndMemes")
    protected Boolean allowStickersAndMemes;

    @JsonProperty("allowCustomMemes")
    protected Boolean allowCustomMemes;

    protected TeamFunSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamFunSettings";
    }

    @Property(name="allowGiphy")
    @JsonIgnore
    public Optional<Boolean> getAllowGiphy() {
        return Optional.ofNullable(allowGiphy);
    }

    public TeamFunSettings withAllowGiphy(Boolean allowGiphy) {
        TeamFunSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamFunSettings");
        _x.allowGiphy = allowGiphy;
        return _x;
    }

    @Property(name="giphyContentRating")
    @JsonIgnore
    public Optional<GiphyRatingType> getGiphyContentRating() {
        return Optional.ofNullable(giphyContentRating);
    }

    public TeamFunSettings withGiphyContentRating(GiphyRatingType giphyContentRating) {
        TeamFunSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamFunSettings");
        _x.giphyContentRating = giphyContentRating;
        return _x;
    }

    @Property(name="allowStickersAndMemes")
    @JsonIgnore
    public Optional<Boolean> getAllowStickersAndMemes() {
        return Optional.ofNullable(allowStickersAndMemes);
    }

    public TeamFunSettings withAllowStickersAndMemes(Boolean allowStickersAndMemes) {
        TeamFunSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamFunSettings");
        _x.allowStickersAndMemes = allowStickersAndMemes;
        return _x;
    }

    @Property(name="allowCustomMemes")
    @JsonIgnore
    public Optional<Boolean> getAllowCustomMemes() {
        return Optional.ofNullable(allowCustomMemes);
    }

    public TeamFunSettings withAllowCustomMemes(Boolean allowCustomMemes) {
        TeamFunSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamFunSettings");
        _x.allowCustomMemes = allowCustomMemes;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allowGiphy;
        private GiphyRatingType giphyContentRating;
        private Boolean allowStickersAndMemes;
        private Boolean allowCustomMemes;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder allowGiphy(Boolean allowGiphy) {
            this.allowGiphy = allowGiphy;
            this.changedFields = changedFields.add("allowGiphy");
            return this;
        }

        public Builder giphyContentRating(GiphyRatingType giphyContentRating) {
            this.giphyContentRating = giphyContentRating;
            this.changedFields = changedFields.add("giphyContentRating");
            return this;
        }

        public Builder allowStickersAndMemes(Boolean allowStickersAndMemes) {
            this.allowStickersAndMemes = allowStickersAndMemes;
            this.changedFields = changedFields.add("allowStickersAndMemes");
            return this;
        }

        public Builder allowCustomMemes(Boolean allowCustomMemes) {
            this.allowCustomMemes = allowCustomMemes;
            this.changedFields = changedFields.add("allowCustomMemes");
            return this;
        }

        public TeamFunSettings build() {
            TeamFunSettings _x = new TeamFunSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.teamFunSettings";
            _x.allowGiphy = allowGiphy;
            _x.giphyContentRating = giphyContentRating;
            _x.allowStickersAndMemes = allowStickersAndMemes;
            _x.allowCustomMemes = allowCustomMemes;
            return _x;
        }
    }

    private TeamFunSettings _copy() {
        TeamFunSettings _x = new TeamFunSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.allowGiphy = allowGiphy;
        _x.giphyContentRating = giphyContentRating;
        _x.allowStickersAndMemes = allowStickersAndMemes;
        _x.allowCustomMemes = allowCustomMemes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamFunSettings[");
        b.append("allowGiphy=");
        b.append(this.allowGiphy);
        b.append(", ");
        b.append("giphyContentRating=");
        b.append(this.giphyContentRating);
        b.append(", ");
        b.append("allowStickersAndMemes=");
        b.append(this.allowStickersAndMemes);
        b.append(", ");
        b.append("allowCustomMemes=");
        b.append(this.allowCustomMemes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
