package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "notifyGuardiansAboutAssignments"})
@JsonInclude(Include.NON_NULL)
public class TeamClassSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("notifyGuardiansAboutAssignments")
    protected Boolean notifyGuardiansAboutAssignments;

    protected TeamClassSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.teamClassSettings";
    }

    @Property(name="notifyGuardiansAboutAssignments")
    @JsonIgnore
    public Optional<Boolean> getNotifyGuardiansAboutAssignments() {
        return Optional.ofNullable(notifyGuardiansAboutAssignments);
    }

    public TeamClassSettings withNotifyGuardiansAboutAssignments(Boolean notifyGuardiansAboutAssignments) {
        TeamClassSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.teamClassSettings");
        _x.notifyGuardiansAboutAssignments = notifyGuardiansAboutAssignments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean notifyGuardiansAboutAssignments;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder notifyGuardiansAboutAssignments(Boolean notifyGuardiansAboutAssignments) {
            this.notifyGuardiansAboutAssignments = notifyGuardiansAboutAssignments;
            this.changedFields = changedFields.add("notifyGuardiansAboutAssignments");
            return this;
        }

        public TeamClassSettings build() {
            TeamClassSettings _x = new TeamClassSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.teamClassSettings";
            _x.notifyGuardiansAboutAssignments = notifyGuardiansAboutAssignments;
            return _x;
        }
    }

    private TeamClassSettings _copy() {
        TeamClassSettings _x = new TeamClassSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.notifyGuardiansAboutAssignments = notifyGuardiansAboutAssignments;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TeamClassSettings[");
        b.append("notifyGuardiansAboutAssignments=");
        b.append(this.notifyGuardiansAboutAssignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
