package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.GroupType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "displayName", 
    "type", 
    "userPrincipalName", 
    "groupType", 
    "modifiedProperties"})
@JsonInclude(Include.NON_NULL)
public class TargetResource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("groupType")
    protected GroupType groupType;

    @JsonProperty("modifiedProperties")
    protected List<ModifiedProperty> modifiedProperties;

    @JsonProperty("modifiedProperties@nextLink")
    protected String modifiedPropertiesNextLink;

    protected TargetResource() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.targetResource";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public TargetResource withId(String id) {
        TargetResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetResource");
        _x.id = id;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TargetResource withDisplayName(String displayName) {
        TargetResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetResource");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public TargetResource withType(String type) {
        TargetResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetResource");
        _x.type = type;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public TargetResource withUserPrincipalName(String userPrincipalName) {
        TargetResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetResource");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="groupType")
    @JsonIgnore
    public Optional<GroupType> getGroupType() {
        return Optional.ofNullable(groupType);
    }

    public TargetResource withGroupType(GroupType groupType) {
        TargetResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.targetResource");
        _x.groupType = groupType;
        return _x;
    }

    @Property(name="modifiedProperties")
    @JsonIgnore
    public CollectionPage<ModifiedProperty> getModifiedProperties() {
        return new CollectionPage<ModifiedProperty>(contextPath, ModifiedProperty.class, modifiedProperties, Optional.ofNullable(modifiedPropertiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="modifiedProperties")
    @JsonIgnore
    public CollectionPage<ModifiedProperty> getModifiedProperties(HttpRequestOptions options) {
        return new CollectionPage<ModifiedProperty>(contextPath, ModifiedProperty.class, modifiedProperties, Optional.ofNullable(modifiedPropertiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String type;
        private String userPrincipalName;
        private GroupType groupType;
        private List<ModifiedProperty> modifiedProperties;
        private String modifiedPropertiesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder groupType(GroupType groupType) {
            this.groupType = groupType;
            this.changedFields = changedFields.add("groupType");
            return this;
        }

        public Builder modifiedProperties(List<ModifiedProperty> modifiedProperties) {
            this.modifiedProperties = modifiedProperties;
            this.changedFields = changedFields.add("modifiedProperties");
            return this;
        }

        public Builder modifiedProperties(ModifiedProperty... modifiedProperties) {
            return modifiedProperties(Arrays.asList(modifiedProperties));
        }

        public Builder modifiedPropertiesNextLink(String modifiedPropertiesNextLink) {
            this.modifiedPropertiesNextLink = modifiedPropertiesNextLink;
            this.changedFields = changedFields.add("modifiedProperties");
            return this;
        }

        public TargetResource build() {
            TargetResource _x = new TargetResource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.targetResource";
            _x.id = id;
            _x.displayName = displayName;
            _x.type = type;
            _x.userPrincipalName = userPrincipalName;
            _x.groupType = groupType;
            _x.modifiedProperties = modifiedProperties;
            _x.modifiedPropertiesNextLink = modifiedPropertiesNextLink;
            return _x;
        }
    }

    private TargetResource _copy() {
        TargetResource _x = new TargetResource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.type = type;
        _x.userPrincipalName = userPrincipalName;
        _x.groupType = groupType;
        _x.modifiedProperties = modifiedProperties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TargetResource[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("groupType=");
        b.append(this.groupType);
        b.append(", ");
        b.append("modifiedProperties=");
        b.append(this.modifiedProperties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
