package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.QuarantineReason;

@JsonPropertyOrder({
    "@odata.type", 
    "currentBegan", 
    "nextAttempt", 
    "reason", 
    "error", 
    "seriesBegan", 
    "seriesCount"})
@JsonInclude(Include.NON_NULL)
public class SynchronizationQuarantine implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("currentBegan")
    protected OffsetDateTime currentBegan;

    @JsonProperty("nextAttempt")
    protected OffsetDateTime nextAttempt;

    @JsonProperty("reason")
    protected QuarantineReason reason;

    @JsonProperty("error")
    protected SynchronizationError error;

    @JsonProperty("seriesBegan")
    protected OffsetDateTime seriesBegan;

    @JsonProperty("seriesCount")
    protected Long seriesCount;

    protected SynchronizationQuarantine() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronizationQuarantine";
    }

    @Property(name="currentBegan")
    @JsonIgnore
    public Optional<OffsetDateTime> getCurrentBegan() {
        return Optional.ofNullable(currentBegan);
    }

    public SynchronizationQuarantine withCurrentBegan(OffsetDateTime currentBegan) {
        SynchronizationQuarantine _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationQuarantine");
        _x.currentBegan = currentBegan;
        return _x;
    }

    @Property(name="nextAttempt")
    @JsonIgnore
    public Optional<OffsetDateTime> getNextAttempt() {
        return Optional.ofNullable(nextAttempt);
    }

    public SynchronizationQuarantine withNextAttempt(OffsetDateTime nextAttempt) {
        SynchronizationQuarantine _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationQuarantine");
        _x.nextAttempt = nextAttempt;
        return _x;
    }

    @Property(name="reason")
    @JsonIgnore
    public Optional<QuarantineReason> getReason() {
        return Optional.ofNullable(reason);
    }

    public SynchronizationQuarantine withReason(QuarantineReason reason) {
        SynchronizationQuarantine _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationQuarantine");
        _x.reason = reason;
        return _x;
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<SynchronizationError> getError() {
        return Optional.ofNullable(error);
    }

    public SynchronizationQuarantine withError(SynchronizationError error) {
        SynchronizationQuarantine _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationQuarantine");
        _x.error = error;
        return _x;
    }

    @Property(name="seriesBegan")
    @JsonIgnore
    public Optional<OffsetDateTime> getSeriesBegan() {
        return Optional.ofNullable(seriesBegan);
    }

    public SynchronizationQuarantine withSeriesBegan(OffsetDateTime seriesBegan) {
        SynchronizationQuarantine _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationQuarantine");
        _x.seriesBegan = seriesBegan;
        return _x;
    }

    @Property(name="seriesCount")
    @JsonIgnore
    public Optional<Long> getSeriesCount() {
        return Optional.ofNullable(seriesCount);
    }

    public SynchronizationQuarantine withSeriesCount(Long seriesCount) {
        SynchronizationQuarantine _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationQuarantine");
        _x.seriesCount = seriesCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime currentBegan;
        private OffsetDateTime nextAttempt;
        private QuarantineReason reason;
        private SynchronizationError error;
        private OffsetDateTime seriesBegan;
        private Long seriesCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder currentBegan(OffsetDateTime currentBegan) {
            this.currentBegan = currentBegan;
            this.changedFields = changedFields.add("currentBegan");
            return this;
        }

        public Builder nextAttempt(OffsetDateTime nextAttempt) {
            this.nextAttempt = nextAttempt;
            this.changedFields = changedFields.add("nextAttempt");
            return this;
        }

        public Builder reason(QuarantineReason reason) {
            this.reason = reason;
            this.changedFields = changedFields.add("reason");
            return this;
        }

        public Builder error(SynchronizationError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder seriesBegan(OffsetDateTime seriesBegan) {
            this.seriesBegan = seriesBegan;
            this.changedFields = changedFields.add("seriesBegan");
            return this;
        }

        public Builder seriesCount(Long seriesCount) {
            this.seriesCount = seriesCount;
            this.changedFields = changedFields.add("seriesCount");
            return this;
        }

        public SynchronizationQuarantine build() {
            SynchronizationQuarantine _x = new SynchronizationQuarantine();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.synchronizationQuarantine";
            _x.currentBegan = currentBegan;
            _x.nextAttempt = nextAttempt;
            _x.reason = reason;
            _x.error = error;
            _x.seriesBegan = seriesBegan;
            _x.seriesCount = seriesCount;
            return _x;
        }
    }

    private SynchronizationQuarantine _copy() {
        SynchronizationQuarantine _x = new SynchronizationQuarantine();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.currentBegan = currentBegan;
        _x.nextAttempt = nextAttempt;
        _x.reason = reason;
        _x.error = error;
        _x.seriesBegan = seriesBegan;
        _x.seriesCount = seriesCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SynchronizationQuarantine[");
        b.append("currentBegan=");
        b.append(this.currentBegan);
        b.append(", ");
        b.append("nextAttempt=");
        b.append(this.nextAttempt);
        b.append(", ");
        b.append("reason=");
        b.append(this.reason);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("seriesBegan=");
        b.append(this.seriesBegan);
        b.append(", ");
        b.append("seriesCount=");
        b.append(this.seriesCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
