package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "objectId", 
    "objectTypeName"})
@JsonInclude(Include.NON_NULL)
public class SynchronizationJobSubject implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("objectId")
    protected String objectId;

    @JsonProperty("objectTypeName")
    protected String objectTypeName;

    protected SynchronizationJobSubject() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronizationJobSubject";
    }

    @Property(name="objectId")
    @JsonIgnore
    public Optional<String> getObjectId() {
        return Optional.ofNullable(objectId);
    }

    public SynchronizationJobSubject withObjectId(String objectId) {
        SynchronizationJobSubject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationJobSubject");
        _x.objectId = objectId;
        return _x;
    }

    @Property(name="objectTypeName")
    @JsonIgnore
    public Optional<String> getObjectTypeName() {
        return Optional.ofNullable(objectTypeName);
    }

    public SynchronizationJobSubject withObjectTypeName(String objectTypeName) {
        SynchronizationJobSubject _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationJobSubject");
        _x.objectTypeName = objectTypeName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String objectId;
        private String objectTypeName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            this.changedFields = changedFields.add("objectId");
            return this;
        }

        public Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            this.changedFields = changedFields.add("objectTypeName");
            return this;
        }

        public SynchronizationJobSubject build() {
            SynchronizationJobSubject _x = new SynchronizationJobSubject();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.synchronizationJobSubject";
            _x.objectId = objectId;
            _x.objectTypeName = objectTypeName;
            return _x;
        }
    }

    private SynchronizationJobSubject _copy() {
        SynchronizationJobSubject _x = new SynchronizationJobSubject();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.objectId = objectId;
        _x.objectTypeName = objectTypeName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SynchronizationJobSubject[");
        b.append("objectId=");
        b.append(this.objectId);
        b.append(", ");
        b.append("objectTypeName=");
        b.append(this.objectTypeName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
