package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "ruleId", 
    "subjects"})
@JsonInclude(Include.NON_NULL)
public class SynchronizationJobApplicationParameters implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ruleId")
    protected String ruleId;

    @JsonProperty("subjects")
    protected List<SynchronizationJobSubject> subjects;

    @JsonProperty("subjects@nextLink")
    protected String subjectsNextLink;

    protected SynchronizationJobApplicationParameters() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.synchronizationJobApplicationParameters";
    }

    @Property(name="ruleId")
    @JsonIgnore
    public Optional<String> getRuleId() {
        return Optional.ofNullable(ruleId);
    }

    public SynchronizationJobApplicationParameters withRuleId(String ruleId) {
        SynchronizationJobApplicationParameters _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.synchronizationJobApplicationParameters");
        _x.ruleId = ruleId;
        return _x;
    }

    @Property(name="subjects")
    @JsonIgnore
    public CollectionPage<SynchronizationJobSubject> getSubjects() {
        return new CollectionPage<SynchronizationJobSubject>(contextPath, SynchronizationJobSubject.class, subjects, Optional.ofNullable(subjectsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="subjects")
    @JsonIgnore
    public CollectionPage<SynchronizationJobSubject> getSubjects(HttpRequestOptions options) {
        return new CollectionPage<SynchronizationJobSubject>(contextPath, SynchronizationJobSubject.class, subjects, Optional.ofNullable(subjectsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String ruleId;
        private List<SynchronizationJobSubject> subjects;
        private String subjectsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            this.changedFields = changedFields.add("ruleId");
            return this;
        }

        public Builder subjects(List<SynchronizationJobSubject> subjects) {
            this.subjects = subjects;
            this.changedFields = changedFields.add("subjects");
            return this;
        }

        public Builder subjects(SynchronizationJobSubject... subjects) {
            return subjects(Arrays.asList(subjects));
        }

        public Builder subjectsNextLink(String subjectsNextLink) {
            this.subjectsNextLink = subjectsNextLink;
            this.changedFields = changedFields.add("subjects");
            return this;
        }

        public SynchronizationJobApplicationParameters build() {
            SynchronizationJobApplicationParameters _x = new SynchronizationJobApplicationParameters();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.synchronizationJobApplicationParameters";
            _x.ruleId = ruleId;
            _x.subjects = subjects;
            _x.subjectsNextLink = subjectsNextLink;
            return _x;
        }
    }

    private SynchronizationJobApplicationParameters _copy() {
        SynchronizationJobApplicationParameters _x = new SynchronizationJobApplicationParameters();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.ruleId = ruleId;
        _x.subjects = subjects;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SynchronizationJobApplicationParameters[");
        b.append("ruleId=");
        b.append(this.ruleId);
        b.append(", ");
        b.append("subjects=");
        b.append(this.subjects);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
