package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "minimumSize", 
    "maximumSize"})
@JsonInclude(Include.NON_NULL)
public class SizeRange implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("minimumSize")
    protected Integer minimumSize;

    @JsonProperty("maximumSize")
    protected Integer maximumSize;

    protected SizeRange() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sizeRange";
    }

    @Property(name="minimumSize")
    @JsonIgnore
    public Optional<Integer> getMinimumSize() {
        return Optional.ofNullable(minimumSize);
    }

    public SizeRange withMinimumSize(Integer minimumSize) {
        SizeRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sizeRange");
        _x.minimumSize = minimumSize;
        return _x;
    }

    @Property(name="maximumSize")
    @JsonIgnore
    public Optional<Integer> getMaximumSize() {
        return Optional.ofNullable(maximumSize);
    }

    public SizeRange withMaximumSize(Integer maximumSize) {
        SizeRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sizeRange");
        _x.maximumSize = maximumSize;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer minimumSize;
        private Integer maximumSize;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder minimumSize(Integer minimumSize) {
            this.minimumSize = minimumSize;
            this.changedFields = changedFields.add("minimumSize");
            return this;
        }

        public Builder maximumSize(Integer maximumSize) {
            this.maximumSize = maximumSize;
            this.changedFields = changedFields.add("maximumSize");
            return this;
        }

        public SizeRange build() {
            SizeRange _x = new SizeRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sizeRange";
            _x.minimumSize = minimumSize;
            _x.maximumSize = maximumSize;
            return _x;
        }
    }

    private SizeRange _copy() {
        SizeRange _x = new SizeRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.minimumSize = minimumSize;
        _x.maximumSize = maximumSize;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SizeRange[");
        b.append("minimumSize=");
        b.append(this.minimumSize);
        b.append(", ");
        b.append("maximumSize=");
        b.append(this.maximumSize);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
