package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "dataLocationCode", 
    "hostname", 
    "root"})
@JsonInclude(Include.NON_NULL)
public class SiteCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dataLocationCode")
    protected String dataLocationCode;

    @JsonProperty("hostname")
    protected String hostname;

    @JsonProperty("root")
    protected Root root;

    protected SiteCollection() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.siteCollection";
    }

    @Property(name="dataLocationCode")
    @JsonIgnore
    public Optional<String> getDataLocationCode() {
        return Optional.ofNullable(dataLocationCode);
    }

    public SiteCollection withDataLocationCode(String dataLocationCode) {
        SiteCollection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.siteCollection");
        _x.dataLocationCode = dataLocationCode;
        return _x;
    }

    @Property(name="hostname")
    @JsonIgnore
    public Optional<String> getHostname() {
        return Optional.ofNullable(hostname);
    }

    public SiteCollection withHostname(String hostname) {
        SiteCollection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.siteCollection");
        _x.hostname = hostname;
        return _x;
    }

    @Property(name="root")
    @JsonIgnore
    public Optional<Root> getRoot() {
        return Optional.ofNullable(root);
    }

    public SiteCollection withRoot(Root root) {
        SiteCollection _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.siteCollection");
        _x.root = root;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String dataLocationCode;
        private String hostname;
        private Root root;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder dataLocationCode(String dataLocationCode) {
            this.dataLocationCode = dataLocationCode;
            this.changedFields = changedFields.add("dataLocationCode");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.changedFields = changedFields.add("hostname");
            return this;
        }

        public Builder root(Root root) {
            this.root = root;
            this.changedFields = changedFields.add("root");
            return this;
        }

        public SiteCollection build() {
            SiteCollection _x = new SiteCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.siteCollection";
            _x.dataLocationCode = dataLocationCode;
            _x.hostname = hostname;
            _x.root = root;
            return _x;
        }
    }

    private SiteCollection _copy() {
        SiteCollection _x = new SiteCollection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.dataLocationCode = dataLocationCode;
        _x.hostname = hostname;
        _x.root = root;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SiteCollection[");
        b.append("dataLocationCode=");
        b.append(this.dataLocationCode);
        b.append(", ");
        b.append("hostname=");
        b.append(this.hostname);
        b.append(", ");
        b.append("root=");
        b.append(this.root);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
