package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "errorCode", 
    "failureReason", 
    "additionalDetails"})
@JsonInclude(Include.NON_NULL)
public class SignInStatus implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("errorCode")
    protected Integer errorCode;

    @JsonProperty("failureReason")
    protected String failureReason;

    @JsonProperty("additionalDetails")
    protected String additionalDetails;

    protected SignInStatus() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.signInStatus";
    }

    @Property(name="errorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    public SignInStatus withErrorCode(Integer errorCode) {
        SignInStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signInStatus");
        _x.errorCode = errorCode;
        return _x;
    }

    @Property(name="failureReason")
    @JsonIgnore
    public Optional<String> getFailureReason() {
        return Optional.ofNullable(failureReason);
    }

    public SignInStatus withFailureReason(String failureReason) {
        SignInStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signInStatus");
        _x.failureReason = failureReason;
        return _x;
    }

    @Property(name="additionalDetails")
    @JsonIgnore
    public Optional<String> getAdditionalDetails() {
        return Optional.ofNullable(additionalDetails);
    }

    public SignInStatus withAdditionalDetails(String additionalDetails) {
        SignInStatus _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signInStatus");
        _x.additionalDetails = additionalDetails;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer errorCode;
        private String failureReason;
        private String additionalDetails;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        public Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            this.changedFields = changedFields.add("failureReason");
            return this;
        }

        public Builder additionalDetails(String additionalDetails) {
            this.additionalDetails = additionalDetails;
            this.changedFields = changedFields.add("additionalDetails");
            return this;
        }

        public SignInStatus build() {
            SignInStatus _x = new SignInStatus();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.signInStatus";
            _x.errorCode = errorCode;
            _x.failureReason = failureReason;
            _x.additionalDetails = additionalDetails;
            return _x;
        }
    }

    private SignInStatus _copy() {
        SignInStatus _x = new SignInStatus();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.errorCode = errorCode;
        _x.failureReason = failureReason;
        _x.additionalDetails = additionalDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SignInStatus[");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("failureReason=");
        b.append(this.failureReason);
        b.append(", ");
        b.append("additionalDetails=");
        b.append(this.additionalDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
