package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "city", 
    "state", 
    "countryOrRegion", 
    "geoCoordinates"})
@JsonInclude(Include.NON_NULL)
public class SignInLocation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("city")
    protected String city;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("countryOrRegion")
    protected String countryOrRegion;

    @JsonProperty("geoCoordinates")
    protected GeoCoordinates geoCoordinates;

    protected SignInLocation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.signInLocation";
    }

    @Property(name="city")
    @JsonIgnore
    public Optional<String> getCity() {
        return Optional.ofNullable(city);
    }

    public SignInLocation withCity(String city) {
        SignInLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signInLocation");
        _x.city = city;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public SignInLocation withState(String state) {
        SignInLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signInLocation");
        _x.state = state;
        return _x;
    }

    @Property(name="countryOrRegion")
    @JsonIgnore
    public Optional<String> getCountryOrRegion() {
        return Optional.ofNullable(countryOrRegion);
    }

    public SignInLocation withCountryOrRegion(String countryOrRegion) {
        SignInLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signInLocation");
        _x.countryOrRegion = countryOrRegion;
        return _x;
    }

    @Property(name="geoCoordinates")
    @JsonIgnore
    public Optional<GeoCoordinates> getGeoCoordinates() {
        return Optional.ofNullable(geoCoordinates);
    }

    public SignInLocation withGeoCoordinates(GeoCoordinates geoCoordinates) {
        SignInLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signInLocation");
        _x.geoCoordinates = geoCoordinates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String city;
        private String state;
        private String countryOrRegion;
        private GeoCoordinates geoCoordinates;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder city(String city) {
            this.city = city;
            this.changedFields = changedFields.add("city");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder countryOrRegion(String countryOrRegion) {
            this.countryOrRegion = countryOrRegion;
            this.changedFields = changedFields.add("countryOrRegion");
            return this;
        }

        public Builder geoCoordinates(GeoCoordinates geoCoordinates) {
            this.geoCoordinates = geoCoordinates;
            this.changedFields = changedFields.add("geoCoordinates");
            return this;
        }

        public SignInLocation build() {
            SignInLocation _x = new SignInLocation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.signInLocation";
            _x.city = city;
            _x.state = state;
            _x.countryOrRegion = countryOrRegion;
            _x.geoCoordinates = geoCoordinates;
            return _x;
        }
    }

    private SignInLocation _copy() {
        SignInLocation _x = new SignInLocation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.city = city;
        _x.state = state;
        _x.countryOrRegion = countryOrRegion;
        _x.geoCoordinates = geoCoordinates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SignInLocation[");
        b.append("city=");
        b.append(this.city);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("countryOrRegion=");
        b.append(this.countryOrRegion);
        b.append(", ");
        b.append("geoCoordinates=");
        b.append(this.geoCoordinates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
