package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "lastSignInDateTime", 
    "lastSignInRequestId"})
@JsonInclude(Include.NON_NULL)
public class SignInActivity implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("lastSignInDateTime")
    protected OffsetDateTime lastSignInDateTime;

    @JsonProperty("lastSignInRequestId")
    protected String lastSignInRequestId;

    protected SignInActivity() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.signInActivity";
    }

    @Property(name="lastSignInDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSignInDateTime() {
        return Optional.ofNullable(lastSignInDateTime);
    }

    public SignInActivity withLastSignInDateTime(OffsetDateTime lastSignInDateTime) {
        SignInActivity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signInActivity");
        _x.lastSignInDateTime = lastSignInDateTime;
        return _x;
    }

    @Property(name="lastSignInRequestId")
    @JsonIgnore
    public Optional<String> getLastSignInRequestId() {
        return Optional.ofNullable(lastSignInRequestId);
    }

    public SignInActivity withLastSignInRequestId(String lastSignInRequestId) {
        SignInActivity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.signInActivity");
        _x.lastSignInRequestId = lastSignInRequestId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime lastSignInDateTime;
        private String lastSignInRequestId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder lastSignInDateTime(OffsetDateTime lastSignInDateTime) {
            this.lastSignInDateTime = lastSignInDateTime;
            this.changedFields = changedFields.add("lastSignInDateTime");
            return this;
        }

        public Builder lastSignInRequestId(String lastSignInRequestId) {
            this.lastSignInRequestId = lastSignInRequestId;
            this.changedFields = changedFields.add("lastSignInRequestId");
            return this;
        }

        public SignInActivity build() {
            SignInActivity _x = new SignInActivity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.signInActivity";
            _x.lastSignInDateTime = lastSignInDateTime;
            _x.lastSignInRequestId = lastSignInRequestId;
            return _x;
        }
    }

    private SignInActivity _copy() {
        SignInActivity _x = new SignInActivity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.lastSignInDateTime = lastSignInDateTime;
        _x.lastSignInRequestId = lastSignInRequestId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SignInActivity[");
        b.append("lastSignInDateTime=");
        b.append(this.lastSignInDateTime);
        b.append(", ");
        b.append("lastSignInRequestId=");
        b.append(this.lastSignInRequestId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
