package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "application", 
    "preventsDownload", 
    "configuratorUrl", 
    "scope", 
    "type", 
    "webHtml", 
    "webUrl"})
@JsonInclude(Include.NON_NULL)
public class SharingLink implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("application")
    protected Identity application;

    @JsonProperty("preventsDownload")
    protected Boolean preventsDownload;

    @JsonProperty("configuratorUrl")
    protected String configuratorUrl;

    @JsonProperty("scope")
    protected String scope;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("webHtml")
    protected String webHtml;

    @JsonProperty("webUrl")
    protected String webUrl;

    protected SharingLink() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharingLink";
    }

    @Property(name="application")
    @JsonIgnore
    public Optional<Identity> getApplication() {
        return Optional.ofNullable(application);
    }

    public SharingLink withApplication(Identity application) {
        SharingLink _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingLink");
        _x.application = application;
        return _x;
    }

    @Property(name="preventsDownload")
    @JsonIgnore
    public Optional<Boolean> getPreventsDownload() {
        return Optional.ofNullable(preventsDownload);
    }

    public SharingLink withPreventsDownload(Boolean preventsDownload) {
        SharingLink _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingLink");
        _x.preventsDownload = preventsDownload;
        return _x;
    }

    @Property(name="configuratorUrl")
    @JsonIgnore
    public Optional<String> getConfiguratorUrl() {
        return Optional.ofNullable(configuratorUrl);
    }

    public SharingLink withConfiguratorUrl(String configuratorUrl) {
        SharingLink _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingLink");
        _x.configuratorUrl = configuratorUrl;
        return _x;
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<String> getScope() {
        return Optional.ofNullable(scope);
    }

    public SharingLink withScope(String scope) {
        SharingLink _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingLink");
        _x.scope = scope;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public SharingLink withType(String type) {
        SharingLink _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingLink");
        _x.type = type;
        return _x;
    }

    @Property(name="webHtml")
    @JsonIgnore
    public Optional<String> getWebHtml() {
        return Optional.ofNullable(webHtml);
    }

    public SharingLink withWebHtml(String webHtml) {
        SharingLink _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingLink");
        _x.webHtml = webHtml;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public SharingLink withWebUrl(String webUrl) {
        SharingLink _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharingLink");
        _x.webUrl = webUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Identity application;
        private Boolean preventsDownload;
        private String configuratorUrl;
        private String scope;
        private String type;
        private String webHtml;
        private String webUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder application(Identity application) {
            this.application = application;
            this.changedFields = changedFields.add("application");
            return this;
        }

        public Builder preventsDownload(Boolean preventsDownload) {
            this.preventsDownload = preventsDownload;
            this.changedFields = changedFields.add("preventsDownload");
            return this;
        }

        public Builder configuratorUrl(String configuratorUrl) {
            this.configuratorUrl = configuratorUrl;
            this.changedFields = changedFields.add("configuratorUrl");
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder webHtml(String webHtml) {
            this.webHtml = webHtml;
            this.changedFields = changedFields.add("webHtml");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public SharingLink build() {
            SharingLink _x = new SharingLink();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sharingLink";
            _x.application = application;
            _x.preventsDownload = preventsDownload;
            _x.configuratorUrl = configuratorUrl;
            _x.scope = scope;
            _x.type = type;
            _x.webHtml = webHtml;
            _x.webUrl = webUrl;
            return _x;
        }
    }

    private SharingLink _copy() {
        SharingLink _x = new SharingLink();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.application = application;
        _x.preventsDownload = preventsDownload;
        _x.configuratorUrl = configuratorUrl;
        _x.scope = scope;
        _x.type = type;
        _x.webHtml = webHtml;
        _x.webUrl = webUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharingLink[");
        b.append("application=");
        b.append(this.application);
        b.append(", ");
        b.append("preventsDownload=");
        b.append(this.preventsDownload);
        b.append(", ");
        b.append("configuratorUrl=");
        b.append(this.configuratorUrl);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("webHtml=");
        b.append(this.webHtml);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
