package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "listId", 
    "listItemId", 
    "listItemUniqueId", 
    "siteId", 
    "siteUrl", 
    "tenantId", 
    "webId"})
@JsonInclude(Include.NON_NULL)
public class SharepointIds implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("listId")
    protected String listId;

    @JsonProperty("listItemId")
    protected String listItemId;

    @JsonProperty("listItemUniqueId")
    protected String listItemUniqueId;

    @JsonProperty("siteId")
    protected String siteId;

    @JsonProperty("siteUrl")
    protected String siteUrl;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("webId")
    protected String webId;

    protected SharepointIds() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharepointIds";
    }

    @Property(name="listId")
    @JsonIgnore
    public Optional<String> getListId() {
        return Optional.ofNullable(listId);
    }

    public SharepointIds withListId(String listId) {
        SharepointIds _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharepointIds");
        _x.listId = listId;
        return _x;
    }

    @Property(name="listItemId")
    @JsonIgnore
    public Optional<String> getListItemId() {
        return Optional.ofNullable(listItemId);
    }

    public SharepointIds withListItemId(String listItemId) {
        SharepointIds _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharepointIds");
        _x.listItemId = listItemId;
        return _x;
    }

    @Property(name="listItemUniqueId")
    @JsonIgnore
    public Optional<String> getListItemUniqueId() {
        return Optional.ofNullable(listItemUniqueId);
    }

    public SharepointIds withListItemUniqueId(String listItemUniqueId) {
        SharepointIds _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharepointIds");
        _x.listItemUniqueId = listItemUniqueId;
        return _x;
    }

    @Property(name="siteId")
    @JsonIgnore
    public Optional<String> getSiteId() {
        return Optional.ofNullable(siteId);
    }

    public SharepointIds withSiteId(String siteId) {
        SharepointIds _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharepointIds");
        _x.siteId = siteId;
        return _x;
    }

    @Property(name="siteUrl")
    @JsonIgnore
    public Optional<String> getSiteUrl() {
        return Optional.ofNullable(siteUrl);
    }

    public SharepointIds withSiteUrl(String siteUrl) {
        SharepointIds _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharepointIds");
        _x.siteUrl = siteUrl;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public SharepointIds withTenantId(String tenantId) {
        SharepointIds _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharepointIds");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="webId")
    @JsonIgnore
    public Optional<String> getWebId() {
        return Optional.ofNullable(webId);
    }

    public SharepointIds withWebId(String webId) {
        SharepointIds _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharepointIds");
        _x.webId = webId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String listId;
        private String listItemId;
        private String listItemUniqueId;
        private String siteId;
        private String siteUrl;
        private String tenantId;
        private String webId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder listId(String listId) {
            this.listId = listId;
            this.changedFields = changedFields.add("listId");
            return this;
        }

        public Builder listItemId(String listItemId) {
            this.listItemId = listItemId;
            this.changedFields = changedFields.add("listItemId");
            return this;
        }

        public Builder listItemUniqueId(String listItemUniqueId) {
            this.listItemUniqueId = listItemUniqueId;
            this.changedFields = changedFields.add("listItemUniqueId");
            return this;
        }

        public Builder siteId(String siteId) {
            this.siteId = siteId;
            this.changedFields = changedFields.add("siteId");
            return this;
        }

        public Builder siteUrl(String siteUrl) {
            this.siteUrl = siteUrl;
            this.changedFields = changedFields.add("siteUrl");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder webId(String webId) {
            this.webId = webId;
            this.changedFields = changedFields.add("webId");
            return this;
        }

        public SharepointIds build() {
            SharepointIds _x = new SharepointIds();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sharepointIds";
            _x.listId = listId;
            _x.listItemId = listItemId;
            _x.listItemUniqueId = listItemUniqueId;
            _x.siteId = siteId;
            _x.siteUrl = siteUrl;
            _x.tenantId = tenantId;
            _x.webId = webId;
            return _x;
        }
    }

    private SharepointIds _copy() {
        SharepointIds _x = new SharepointIds();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.listId = listId;
        _x.listItemId = listItemId;
        _x.listItemUniqueId = listItemUniqueId;
        _x.siteId = siteId;
        _x.siteUrl = siteUrl;
        _x.tenantId = tenantId;
        _x.webId = webId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharepointIds[");
        b.append("listId=");
        b.append(this.listId);
        b.append(", ");
        b.append("listItemId=");
        b.append(this.listItemId);
        b.append(", ");
        b.append("listItemUniqueId=");
        b.append(this.listItemUniqueId);
        b.append(", ");
        b.append("siteId=");
        b.append(this.siteId);
        b.append(", ");
        b.append("siteUrl=");
        b.append(this.siteUrl);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("webId=");
        b.append(this.webId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
