package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.SharedPCAccountDeletionPolicyType;


/**
 * <i>“SharedPC Account Manager Policy. Only applies when the account manager is
 * enabled.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountDeletionPolicy", 
    "cacheAccountsAboveDiskFreePercentage", 
    "inactiveThresholdDays", 
    "removeAccountsBelowDiskFreePercentage"})
@JsonInclude(Include.NON_NULL)
public class SharedPCAccountManagerPolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("accountDeletionPolicy")
    protected SharedPCAccountDeletionPolicyType accountDeletionPolicy;

    @JsonProperty("cacheAccountsAboveDiskFreePercentage")
    protected Integer cacheAccountsAboveDiskFreePercentage;

    @JsonProperty("inactiveThresholdDays")
    protected Integer inactiveThresholdDays;

    @JsonProperty("removeAccountsBelowDiskFreePercentage")
    protected Integer removeAccountsBelowDiskFreePercentage;

    protected SharedPCAccountManagerPolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharedPCAccountManagerPolicy";
    }

    /**
     * <i>“Configures when accounts are deleted.”</i>
     * 
     * @return property accountDeletionPolicy
     */
    @Property(name="accountDeletionPolicy")
    @JsonIgnore
    public Optional<SharedPCAccountDeletionPolicyType> getAccountDeletionPolicy() {
        return Optional.ofNullable(accountDeletionPolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * accountDeletionPolicy} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Configures when accounts are deleted.”</i>
     * 
     * @param accountDeletionPolicy
     *            new value of {@code accountDeletionPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountDeletionPolicy} field changed
     */
    public SharedPCAccountManagerPolicy withAccountDeletionPolicy(SharedPCAccountDeletionPolicyType accountDeletionPolicy) {
        SharedPCAccountManagerPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCAccountManagerPolicy");
        _x.accountDeletionPolicy = accountDeletionPolicy;
        return _x;
    }

    /**
     * <i>“Sets the percentage of available disk space a PC should have before it stops
     * deleting cached shared PC accounts. Only applies when AccountDeletionPolicy is
     * DiskSpaceThreshold or DiskSpaceThresholdOrInactiveThreshold. Valid values 0 to
     * 100”</i>
     * 
     * @return property cacheAccountsAboveDiskFreePercentage
     */
    @Property(name="cacheAccountsAboveDiskFreePercentage")
    @JsonIgnore
    public Optional<Integer> getCacheAccountsAboveDiskFreePercentage() {
        return Optional.ofNullable(cacheAccountsAboveDiskFreePercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cacheAccountsAboveDiskFreePercentage} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Sets the percentage of available disk space a PC should have before it stops
     * deleting cached shared PC accounts. Only applies when AccountDeletionPolicy is
     * DiskSpaceThreshold or DiskSpaceThresholdOrInactiveThreshold. Valid values 0 to
     * 100”</i>
     * 
     * @param cacheAccountsAboveDiskFreePercentage
     *            new value of {@code cacheAccountsAboveDiskFreePercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cacheAccountsAboveDiskFreePercentage} field changed
     */
    public SharedPCAccountManagerPolicy withCacheAccountsAboveDiskFreePercentage(Integer cacheAccountsAboveDiskFreePercentage) {
        SharedPCAccountManagerPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCAccountManagerPolicy");
        _x.cacheAccountsAboveDiskFreePercentage = cacheAccountsAboveDiskFreePercentage;
        return _x;
    }

    /**
     * <i>“Specifies when the accounts will start being deleted when they have not been
     * logged on during the specified period, given as number of days. Only applies
     * when AccountDeletionPolicy is DiskSpaceThreshold or
     * DiskSpaceThresholdOrInactiveThreshold.”</i>
     * 
     * @return property inactiveThresholdDays
     */
    @Property(name="inactiveThresholdDays")
    @JsonIgnore
    public Optional<Integer> getInactiveThresholdDays() {
        return Optional.ofNullable(inactiveThresholdDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * inactiveThresholdDays} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Specifies when the accounts will start being deleted when they have not been
     * logged on during the specified period, given as number of days. Only applies
     * when AccountDeletionPolicy is DiskSpaceThreshold or
     * DiskSpaceThresholdOrInactiveThreshold.”</i>
     * 
     * @param inactiveThresholdDays
     *            new value of {@code inactiveThresholdDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inactiveThresholdDays} field changed
     */
    public SharedPCAccountManagerPolicy withInactiveThresholdDays(Integer inactiveThresholdDays) {
        SharedPCAccountManagerPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCAccountManagerPolicy");
        _x.inactiveThresholdDays = inactiveThresholdDays;
        return _x;
    }

    /**
     * <i>“Sets the percentage of disk space remaining on a PC before cached accounts will
     * be deleted to free disk space. Accounts that have been inactive the longest will
     * be deleted first. Only applies when AccountDeletionPolicy is
     * DiskSpaceThresholdOrInactiveThreshold. Valid values 0 to 100”</i>
     * 
     * @return property removeAccountsBelowDiskFreePercentage
     */
    @Property(name="removeAccountsBelowDiskFreePercentage")
    @JsonIgnore
    public Optional<Integer> getRemoveAccountsBelowDiskFreePercentage() {
        return Optional.ofNullable(removeAccountsBelowDiskFreePercentage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * removeAccountsBelowDiskFreePercentage} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Sets the percentage of disk space remaining on a PC before cached accounts will
     * be deleted to free disk space. Accounts that have been inactive the longest will
     * be deleted first. Only applies when AccountDeletionPolicy is
     * DiskSpaceThresholdOrInactiveThreshold. Valid values 0 to 100”</i>
     * 
     * @param removeAccountsBelowDiskFreePercentage
     *            new value of {@code removeAccountsBelowDiskFreePercentage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code removeAccountsBelowDiskFreePercentage} field changed
     */
    public SharedPCAccountManagerPolicy withRemoveAccountsBelowDiskFreePercentage(Integer removeAccountsBelowDiskFreePercentage) {
        SharedPCAccountManagerPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharedPCAccountManagerPolicy");
        _x.removeAccountsBelowDiskFreePercentage = removeAccountsBelowDiskFreePercentage;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SharedPCAccountDeletionPolicyType accountDeletionPolicy;
        private Integer cacheAccountsAboveDiskFreePercentage;
        private Integer inactiveThresholdDays;
        private Integer removeAccountsBelowDiskFreePercentage;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Configures when accounts are deleted.”</i>
         * 
         * @param accountDeletionPolicy
         *            value of {@code accountDeletionPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountDeletionPolicy(SharedPCAccountDeletionPolicyType accountDeletionPolicy) {
            this.accountDeletionPolicy = accountDeletionPolicy;
            this.changedFields = changedFields.add("accountDeletionPolicy");
            return this;
        }

        /**
         * <i>“Sets the percentage of available disk space a PC should have before it stops
         * deleting cached shared PC accounts. Only applies when AccountDeletionPolicy is
         * DiskSpaceThreshold or DiskSpaceThresholdOrInactiveThreshold. Valid values 0 to
         * 100”</i>
         * 
         * @param cacheAccountsAboveDiskFreePercentage
         *            value of {@code cacheAccountsAboveDiskFreePercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cacheAccountsAboveDiskFreePercentage(Integer cacheAccountsAboveDiskFreePercentage) {
            this.cacheAccountsAboveDiskFreePercentage = cacheAccountsAboveDiskFreePercentage;
            this.changedFields = changedFields.add("cacheAccountsAboveDiskFreePercentage");
            return this;
        }

        /**
         * <i>“Specifies when the accounts will start being deleted when they have not been
         * logged on during the specified period, given as number of days. Only applies
         * when AccountDeletionPolicy is DiskSpaceThreshold or
         * DiskSpaceThresholdOrInactiveThreshold.”</i>
         * 
         * @param inactiveThresholdDays
         *            value of {@code inactiveThresholdDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inactiveThresholdDays(Integer inactiveThresholdDays) {
            this.inactiveThresholdDays = inactiveThresholdDays;
            this.changedFields = changedFields.add("inactiveThresholdDays");
            return this;
        }

        /**
         * <i>“Sets the percentage of disk space remaining on a PC before cached accounts will
         * be deleted to free disk space. Accounts that have been inactive the longest will
         * be deleted first. Only applies when AccountDeletionPolicy is
         * DiskSpaceThresholdOrInactiveThreshold. Valid values 0 to 100”</i>
         * 
         * @param removeAccountsBelowDiskFreePercentage
         *            value of {@code removeAccountsBelowDiskFreePercentage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder removeAccountsBelowDiskFreePercentage(Integer removeAccountsBelowDiskFreePercentage) {
            this.removeAccountsBelowDiskFreePercentage = removeAccountsBelowDiskFreePercentage;
            this.changedFields = changedFields.add("removeAccountsBelowDiskFreePercentage");
            return this;
        }

        public SharedPCAccountManagerPolicy build() {
            SharedPCAccountManagerPolicy _x = new SharedPCAccountManagerPolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sharedPCAccountManagerPolicy";
            _x.accountDeletionPolicy = accountDeletionPolicy;
            _x.cacheAccountsAboveDiskFreePercentage = cacheAccountsAboveDiskFreePercentage;
            _x.inactiveThresholdDays = inactiveThresholdDays;
            _x.removeAccountsBelowDiskFreePercentage = removeAccountsBelowDiskFreePercentage;
            return _x;
        }
    }

    private SharedPCAccountManagerPolicy _copy() {
        SharedPCAccountManagerPolicy _x = new SharedPCAccountManagerPolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.accountDeletionPolicy = accountDeletionPolicy;
        _x.cacheAccountsAboveDiskFreePercentage = cacheAccountsAboveDiskFreePercentage;
        _x.inactiveThresholdDays = inactiveThresholdDays;
        _x.removeAccountsBelowDiskFreePercentage = removeAccountsBelowDiskFreePercentage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharedPCAccountManagerPolicy[");
        b.append("accountDeletionPolicy=");
        b.append(this.accountDeletionPolicy);
        b.append(", ");
        b.append("cacheAccountsAboveDiskFreePercentage=");
        b.append(this.cacheAccountsAboveDiskFreePercentage);
        b.append(", ");
        b.append("inactiveThresholdDays=");
        b.append(this.inactiveThresholdDays);
        b.append(", ");
        b.append("removeAccountsBelowDiskFreePercentage=");
        b.append(this.removeAccountsBelowDiskFreePercentage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
