package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "owner", 
    "scope", 
    "sharedBy", 
    "sharedDateTime"})
@JsonInclude(Include.NON_NULL)
public class Shared implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("owner")
    protected IdentitySet owner;

    @JsonProperty("scope")
    protected String scope;

    @JsonProperty("sharedBy")
    protected IdentitySet sharedBy;

    @JsonProperty("sharedDateTime")
    protected OffsetDateTime sharedDateTime;

    protected Shared() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.shared";
    }

    @Property(name="owner")
    @JsonIgnore
    public Optional<IdentitySet> getOwner() {
        return Optional.ofNullable(owner);
    }

    public Shared withOwner(IdentitySet owner) {
        Shared _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.shared");
        _x.owner = owner;
        return _x;
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<String> getScope() {
        return Optional.ofNullable(scope);
    }

    public Shared withScope(String scope) {
        Shared _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.shared");
        _x.scope = scope;
        return _x;
    }

    @Property(name="sharedBy")
    @JsonIgnore
    public Optional<IdentitySet> getSharedBy() {
        return Optional.ofNullable(sharedBy);
    }

    public Shared withSharedBy(IdentitySet sharedBy) {
        Shared _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.shared");
        _x.sharedBy = sharedBy;
        return _x;
    }

    @Property(name="sharedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSharedDateTime() {
        return Optional.ofNullable(sharedDateTime);
    }

    public Shared withSharedDateTime(OffsetDateTime sharedDateTime) {
        Shared _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.shared");
        _x.sharedDateTime = sharedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet owner;
        private String scope;
        private IdentitySet sharedBy;
        private OffsetDateTime sharedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder owner(IdentitySet owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder sharedBy(IdentitySet sharedBy) {
            this.sharedBy = sharedBy;
            this.changedFields = changedFields.add("sharedBy");
            return this;
        }

        public Builder sharedDateTime(OffsetDateTime sharedDateTime) {
            this.sharedDateTime = sharedDateTime;
            this.changedFields = changedFields.add("sharedDateTime");
            return this;
        }

        public Shared build() {
            Shared _x = new Shared();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.shared";
            _x.owner = owner;
            _x.scope = scope;
            _x.sharedBy = sharedBy;
            _x.sharedDateTime = sharedDateTime;
            return _x;
        }
    }

    private Shared _copy() {
        Shared _x = new Shared();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.owner = owner;
        _x.scope = scope;
        _x.sharedBy = sharedBy;
        _x.sharedDateTime = sharedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Shared[");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("sharedBy=");
        b.append(this.sharedBy);
        b.append(", ");
        b.append("sharedDateTime=");
        b.append(this.sharedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
