package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "recipients"})
@JsonInclude(Include.NON_NULL)
public class ShareAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("recipients")
    protected List<IdentitySet> recipients;

    @JsonProperty("recipients@nextLink")
    protected String recipientsNextLink;

    protected ShareAction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.shareAction";
    }

    @Property(name="recipients")
    @JsonIgnore
    public CollectionPage<IdentitySet> getRecipients() {
        return new CollectionPage<IdentitySet>(contextPath, IdentitySet.class, recipients, Optional.ofNullable(recipientsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="recipients")
    @JsonIgnore
    public CollectionPage<IdentitySet> getRecipients(HttpRequestOptions options) {
        return new CollectionPage<IdentitySet>(contextPath, IdentitySet.class, recipients, Optional.ofNullable(recipientsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<IdentitySet> recipients;
        private String recipientsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder recipients(List<IdentitySet> recipients) {
            this.recipients = recipients;
            this.changedFields = changedFields.add("recipients");
            return this;
        }

        public Builder recipients(IdentitySet... recipients) {
            return recipients(Arrays.asList(recipients));
        }

        public Builder recipientsNextLink(String recipientsNextLink) {
            this.recipientsNextLink = recipientsNextLink;
            this.changedFields = changedFields.add("recipients");
            return this;
        }

        public ShareAction build() {
            ShareAction _x = new ShareAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.shareAction";
            _x.recipients = recipients;
            _x.recipientsNextLink = recipientsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ShareAction[");
        b.append("recipients=");
        b.append(this.recipients);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
