package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "type", 
    "defaultValue", 
    "description"})
@JsonInclude(Include.NON_NULL)
public class SettingTemplateValue implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("defaultValue")
    protected String defaultValue;

    @JsonProperty("description")
    protected String description;

    protected SettingTemplateValue() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.settingTemplateValue";
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public SettingTemplateValue withName(String name) {
        SettingTemplateValue _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.settingTemplateValue");
        _x.name = name;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public SettingTemplateValue withType(String type) {
        SettingTemplateValue _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.settingTemplateValue");
        _x.type = type;
        return _x;
    }

    @Property(name="defaultValue")
    @JsonIgnore
    public Optional<String> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    public SettingTemplateValue withDefaultValue(String defaultValue) {
        SettingTemplateValue _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.settingTemplateValue");
        _x.defaultValue = defaultValue;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public SettingTemplateValue withDescription(String description) {
        SettingTemplateValue _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.settingTemplateValue");
        _x.description = description;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String type;
        private String defaultValue;
        private String description;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.changedFields = changedFields.add("defaultValue");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public SettingTemplateValue build() {
            SettingTemplateValue _x = new SettingTemplateValue();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.settingTemplateValue";
            _x.name = name;
            _x.type = type;
            _x.defaultValue = defaultValue;
            _x.description = description;
            return _x;
        }
    }

    private SettingTemplateValue _copy() {
        SettingTemplateValue _x = new SettingTemplateValue();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.type = type;
        _x.defaultValue = defaultValue;
        _x.description = description;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SettingTemplateValue[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("defaultValue=");
        b.append(this.defaultValue);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
