package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "servicePlanId", 
    "servicePlanName", 
    "provisioningStatus", 
    "appliesTo"})
@JsonInclude(Include.NON_NULL)
public class ServicePlanInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("servicePlanId")
    protected String servicePlanId;

    @JsonProperty("servicePlanName")
    protected String servicePlanName;

    @JsonProperty("provisioningStatus")
    protected String provisioningStatus;

    @JsonProperty("appliesTo")
    protected String appliesTo;

    protected ServicePlanInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.servicePlanInfo";
    }

    @Property(name="servicePlanId")
    @JsonIgnore
    public Optional<String> getServicePlanId() {
        return Optional.ofNullable(servicePlanId);
    }

    public ServicePlanInfo withServicePlanId(String servicePlanId) {
        ServicePlanInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePlanInfo");
        _x.servicePlanId = servicePlanId;
        return _x;
    }

    @Property(name="servicePlanName")
    @JsonIgnore
    public Optional<String> getServicePlanName() {
        return Optional.ofNullable(servicePlanName);
    }

    public ServicePlanInfo withServicePlanName(String servicePlanName) {
        ServicePlanInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePlanInfo");
        _x.servicePlanName = servicePlanName;
        return _x;
    }

    @Property(name="provisioningStatus")
    @JsonIgnore
    public Optional<String> getProvisioningStatus() {
        return Optional.ofNullable(provisioningStatus);
    }

    public ServicePlanInfo withProvisioningStatus(String provisioningStatus) {
        ServicePlanInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePlanInfo");
        _x.provisioningStatus = provisioningStatus;
        return _x;
    }

    @Property(name="appliesTo")
    @JsonIgnore
    public Optional<String> getAppliesTo() {
        return Optional.ofNullable(appliesTo);
    }

    public ServicePlanInfo withAppliesTo(String appliesTo) {
        ServicePlanInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePlanInfo");
        _x.appliesTo = appliesTo;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String servicePlanId;
        private String servicePlanName;
        private String provisioningStatus;
        private String appliesTo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder servicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
            this.changedFields = changedFields.add("servicePlanId");
            return this;
        }

        public Builder servicePlanName(String servicePlanName) {
            this.servicePlanName = servicePlanName;
            this.changedFields = changedFields.add("servicePlanName");
            return this;
        }

        public Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            this.changedFields = changedFields.add("provisioningStatus");
            return this;
        }

        public Builder appliesTo(String appliesTo) {
            this.appliesTo = appliesTo;
            this.changedFields = changedFields.add("appliesTo");
            return this;
        }

        public ServicePlanInfo build() {
            ServicePlanInfo _x = new ServicePlanInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.servicePlanInfo";
            _x.servicePlanId = servicePlanId;
            _x.servicePlanName = servicePlanName;
            _x.provisioningStatus = provisioningStatus;
            _x.appliesTo = appliesTo;
            return _x;
        }
    }

    private ServicePlanInfo _copy() {
        ServicePlanInfo _x = new ServicePlanInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.servicePlanId = servicePlanId;
        _x.servicePlanName = servicePlanName;
        _x.provisioningStatus = provisioningStatus;
        _x.appliesTo = appliesTo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServicePlanInfo[");
        b.append("servicePlanId=");
        b.append(this.servicePlanId);
        b.append(", ");
        b.append("servicePlanName=");
        b.append(this.servicePlanName);
        b.append(", ");
        b.append("provisioningStatus=");
        b.append(this.provisioningStatus);
        b.append(", ");
        b.append("appliesTo=");
        b.append(this.appliesTo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
