package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "idMatch", 
    "offset", 
    "length", 
    "evidences"})
@JsonInclude(Include.NON_NULL)
public class SensitiveContentLocation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("idMatch")
    protected String idMatch;

    @JsonProperty("offset")
    protected Integer offset;

    @JsonProperty("length")
    protected Integer length;

    @JsonProperty("evidences")
    protected List<SensitiveContentEvidence> evidences;

    @JsonProperty("evidences@nextLink")
    protected String evidencesNextLink;

    protected SensitiveContentLocation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sensitiveContentLocation";
    }

    @Property(name="idMatch")
    @JsonIgnore
    public Optional<String> getIdMatch() {
        return Optional.ofNullable(idMatch);
    }

    public SensitiveContentLocation withIdMatch(String idMatch) {
        SensitiveContentLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveContentLocation");
        _x.idMatch = idMatch;
        return _x;
    }

    @Property(name="offset")
    @JsonIgnore
    public Optional<Integer> getOffset() {
        return Optional.ofNullable(offset);
    }

    public SensitiveContentLocation withOffset(Integer offset) {
        SensitiveContentLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveContentLocation");
        _x.offset = offset;
        return _x;
    }

    @Property(name="length")
    @JsonIgnore
    public Optional<Integer> getLength() {
        return Optional.ofNullable(length);
    }

    public SensitiveContentLocation withLength(Integer length) {
        SensitiveContentLocation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitiveContentLocation");
        _x.length = length;
        return _x;
    }

    @Property(name="evidences")
    @JsonIgnore
    public CollectionPage<SensitiveContentEvidence> getEvidences() {
        return new CollectionPage<SensitiveContentEvidence>(contextPath, SensitiveContentEvidence.class, evidences, Optional.ofNullable(evidencesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="evidences")
    @JsonIgnore
    public CollectionPage<SensitiveContentEvidence> getEvidences(HttpRequestOptions options) {
        return new CollectionPage<SensitiveContentEvidence>(contextPath, SensitiveContentEvidence.class, evidences, Optional.ofNullable(evidencesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String idMatch;
        private Integer offset;
        private Integer length;
        private List<SensitiveContentEvidence> evidences;
        private String evidencesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder idMatch(String idMatch) {
            this.idMatch = idMatch;
            this.changedFields = changedFields.add("idMatch");
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = offset;
            this.changedFields = changedFields.add("offset");
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            this.changedFields = changedFields.add("length");
            return this;
        }

        public Builder evidences(List<SensitiveContentEvidence> evidences) {
            this.evidences = evidences;
            this.changedFields = changedFields.add("evidences");
            return this;
        }

        public Builder evidences(SensitiveContentEvidence... evidences) {
            return evidences(Arrays.asList(evidences));
        }

        public Builder evidencesNextLink(String evidencesNextLink) {
            this.evidencesNextLink = evidencesNextLink;
            this.changedFields = changedFields.add("evidences");
            return this;
        }

        public SensitiveContentLocation build() {
            SensitiveContentLocation _x = new SensitiveContentLocation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sensitiveContentLocation";
            _x.idMatch = idMatch;
            _x.offset = offset;
            _x.length = length;
            _x.evidences = evidences;
            _x.evidencesNextLink = evidencesNextLink;
            return _x;
        }
    }

    private SensitiveContentLocation _copy() {
        SensitiveContentLocation _x = new SensitiveContentLocation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.idMatch = idMatch;
        _x.offset = offset;
        _x.length = length;
        _x.evidences = evidences;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SensitiveContentLocation[");
        b.append("idMatch=");
        b.append(this.idMatch);
        b.append(", ");
        b.append("offset=");
        b.append(this.offset);
        b.append(", ");
        b.append("length=");
        b.append(this.length);
        b.append(", ");
        b.append("evidences=");
        b.append(this.evidences);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
