package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "provider", 
    "providerVersion", 
    "subProvider", 
    "vendor"})
@JsonInclude(Include.NON_NULL)
public class SecurityVendorInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("provider")
    protected String provider;

    @JsonProperty("providerVersion")
    protected String providerVersion;

    @JsonProperty("subProvider")
    protected String subProvider;

    @JsonProperty("vendor")
    protected String vendor;

    protected SecurityVendorInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityVendorInformation";
    }

    @Property(name="provider")
    @JsonIgnore
    public Optional<String> getProvider() {
        return Optional.ofNullable(provider);
    }

    public SecurityVendorInformation withProvider(String provider) {
        SecurityVendorInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityVendorInformation");
        _x.provider = provider;
        return _x;
    }

    @Property(name="providerVersion")
    @JsonIgnore
    public Optional<String> getProviderVersion() {
        return Optional.ofNullable(providerVersion);
    }

    public SecurityVendorInformation withProviderVersion(String providerVersion) {
        SecurityVendorInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityVendorInformation");
        _x.providerVersion = providerVersion;
        return _x;
    }

    @Property(name="subProvider")
    @JsonIgnore
    public Optional<String> getSubProvider() {
        return Optional.ofNullable(subProvider);
    }

    public SecurityVendorInformation withSubProvider(String subProvider) {
        SecurityVendorInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityVendorInformation");
        _x.subProvider = subProvider;
        return _x;
    }

    @Property(name="vendor")
    @JsonIgnore
    public Optional<String> getVendor() {
        return Optional.ofNullable(vendor);
    }

    public SecurityVendorInformation withVendor(String vendor) {
        SecurityVendorInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityVendorInformation");
        _x.vendor = vendor;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String provider;
        private String providerVersion;
        private String subProvider;
        private String vendor;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder provider(String provider) {
            this.provider = provider;
            this.changedFields = changedFields.add("provider");
            return this;
        }

        public Builder providerVersion(String providerVersion) {
            this.providerVersion = providerVersion;
            this.changedFields = changedFields.add("providerVersion");
            return this;
        }

        public Builder subProvider(String subProvider) {
            this.subProvider = subProvider;
            this.changedFields = changedFields.add("subProvider");
            return this;
        }

        public Builder vendor(String vendor) {
            this.vendor = vendor;
            this.changedFields = changedFields.add("vendor");
            return this;
        }

        public SecurityVendorInformation build() {
            SecurityVendorInformation _x = new SecurityVendorInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.securityVendorInformation";
            _x.provider = provider;
            _x.providerVersion = providerVersion;
            _x.subProvider = subProvider;
            _x.vendor = vendor;
            return _x;
        }
    }

    private SecurityVendorInformation _copy() {
        SecurityVendorInformation _x = new SecurityVendorInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.provider = provider;
        _x.providerVersion = providerVersion;
        _x.subProvider = subProvider;
        _x.vendor = vendor;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityVendorInformation[");
        b.append("provider=");
        b.append(this.provider);
        b.append(", ");
        b.append("providerVersion=");
        b.append(this.providerVersion);
        b.append(", ");
        b.append("subProvider=");
        b.append(this.subProvider);
        b.append(", ");
        b.append("vendor=");
        b.append(this.vendor);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
