package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedTo", 
    "comment", 
    "state", 
    "updatedBy", 
    "updatedDateTime"})
@JsonInclude(Include.NON_NULL)
public class SecureScoreControlStateUpdate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("assignedTo")
    protected String assignedTo;

    @JsonProperty("comment")
    protected String comment;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("updatedBy")
    protected String updatedBy;

    @JsonProperty("updatedDateTime")
    protected OffsetDateTime updatedDateTime;

    protected SecureScoreControlStateUpdate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.secureScoreControlStateUpdate";
    }

    @Property(name="assignedTo")
    @JsonIgnore
    public Optional<String> getAssignedTo() {
        return Optional.ofNullable(assignedTo);
    }

    public SecureScoreControlStateUpdate withAssignedTo(String assignedTo) {
        SecureScoreControlStateUpdate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlStateUpdate");
        _x.assignedTo = assignedTo;
        return _x;
    }

    @Property(name="comment")
    @JsonIgnore
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    public SecureScoreControlStateUpdate withComment(String comment) {
        SecureScoreControlStateUpdate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlStateUpdate");
        _x.comment = comment;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public SecureScoreControlStateUpdate withState(String state) {
        SecureScoreControlStateUpdate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlStateUpdate");
        _x.state = state;
        return _x;
    }

    @Property(name="updatedBy")
    @JsonIgnore
    public Optional<String> getUpdatedBy() {
        return Optional.ofNullable(updatedBy);
    }

    public SecureScoreControlStateUpdate withUpdatedBy(String updatedBy) {
        SecureScoreControlStateUpdate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlStateUpdate");
        _x.updatedBy = updatedBy;
        return _x;
    }

    @Property(name="updatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getUpdatedDateTime() {
        return Optional.ofNullable(updatedDateTime);
    }

    public SecureScoreControlStateUpdate withUpdatedDateTime(OffsetDateTime updatedDateTime) {
        SecureScoreControlStateUpdate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlStateUpdate");
        _x.updatedDateTime = updatedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String assignedTo;
        private String comment;
        private String state;
        private String updatedBy;
        private OffsetDateTime updatedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder assignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
            this.changedFields = changedFields.add("assignedTo");
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            this.changedFields = changedFields.add("comment");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            this.changedFields = changedFields.add("updatedBy");
            return this;
        }

        public Builder updatedDateTime(OffsetDateTime updatedDateTime) {
            this.updatedDateTime = updatedDateTime;
            this.changedFields = changedFields.add("updatedDateTime");
            return this;
        }

        public SecureScoreControlStateUpdate build() {
            SecureScoreControlStateUpdate _x = new SecureScoreControlStateUpdate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.secureScoreControlStateUpdate";
            _x.assignedTo = assignedTo;
            _x.comment = comment;
            _x.state = state;
            _x.updatedBy = updatedBy;
            _x.updatedDateTime = updatedDateTime;
            return _x;
        }
    }

    private SecureScoreControlStateUpdate _copy() {
        SecureScoreControlStateUpdate _x = new SecureScoreControlStateUpdate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.assignedTo = assignedTo;
        _x.comment = comment;
        _x.state = state;
        _x.updatedBy = updatedBy;
        _x.updatedDateTime = updatedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecureScoreControlStateUpdate[");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("comment=");
        b.append(this.comment);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("updatedBy=");
        b.append(this.updatedBy);
        b.append(", ");
        b.append("updatedDateTime=");
        b.append(this.updatedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
