package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "oneNoteClientUrl", 
    "oneNoteWebUrl"})
@JsonInclude(Include.NON_NULL)
public class SectionLinks implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("oneNoteClientUrl")
    protected ExternalLink oneNoteClientUrl;

    @JsonProperty("oneNoteWebUrl")
    protected ExternalLink oneNoteWebUrl;

    protected SectionLinks() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sectionLinks";
    }

    @Property(name="oneNoteClientUrl")
    @JsonIgnore
    public Optional<ExternalLink> getOneNoteClientUrl() {
        return Optional.ofNullable(oneNoteClientUrl);
    }

    public SectionLinks withOneNoteClientUrl(ExternalLink oneNoteClientUrl) {
        SectionLinks _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sectionLinks");
        _x.oneNoteClientUrl = oneNoteClientUrl;
        return _x;
    }

    @Property(name="oneNoteWebUrl")
    @JsonIgnore
    public Optional<ExternalLink> getOneNoteWebUrl() {
        return Optional.ofNullable(oneNoteWebUrl);
    }

    public SectionLinks withOneNoteWebUrl(ExternalLink oneNoteWebUrl) {
        SectionLinks _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sectionLinks");
        _x.oneNoteWebUrl = oneNoteWebUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ExternalLink oneNoteClientUrl;
        private ExternalLink oneNoteWebUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder oneNoteClientUrl(ExternalLink oneNoteClientUrl) {
            this.oneNoteClientUrl = oneNoteClientUrl;
            this.changedFields = changedFields.add("oneNoteClientUrl");
            return this;
        }

        public Builder oneNoteWebUrl(ExternalLink oneNoteWebUrl) {
            this.oneNoteWebUrl = oneNoteWebUrl;
            this.changedFields = changedFields.add("oneNoteWebUrl");
            return this;
        }

        public SectionLinks build() {
            SectionLinks _x = new SectionLinks();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sectionLinks";
            _x.oneNoteClientUrl = oneNoteClientUrl;
            _x.oneNoteWebUrl = oneNoteWebUrl;
            return _x;
        }
    }

    private SectionLinks _copy() {
        SectionLinks _x = new SectionLinks();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.oneNoteClientUrl = oneNoteClientUrl;
        _x.oneNoteWebUrl = oneNoteWebUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SectionLinks[");
        b.append("oneNoteClientUrl=");
        b.append(this.oneNoteClientUrl);
        b.append(", ");
        b.append("oneNoteWebUrl=");
        b.append(this.oneNoteWebUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
