package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "searchTerms", 
    "hitsContainers"})
@JsonInclude(Include.NON_NULL)
public class SearchResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("searchTerms")
    protected List<String> searchTerms;

    @JsonProperty("searchTerms@nextLink")
    protected String searchTermsNextLink;

    @JsonProperty("hitsContainers")
    protected List<SearchHitsContainer> hitsContainers;

    @JsonProperty("hitsContainers@nextLink")
    protected String hitsContainersNextLink;

    protected SearchResponse() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchResponse";
    }

    @Property(name="searchTerms")
    @JsonIgnore
    public CollectionPage<String> getSearchTerms() {
        return new CollectionPage<String>(contextPath, String.class, searchTerms, Optional.ofNullable(searchTermsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="searchTerms")
    @JsonIgnore
    public CollectionPage<String> getSearchTerms(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, searchTerms, Optional.ofNullable(searchTermsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="hitsContainers")
    @JsonIgnore
    public CollectionPage<SearchHitsContainer> getHitsContainers() {
        return new CollectionPage<SearchHitsContainer>(contextPath, SearchHitsContainer.class, hitsContainers, Optional.ofNullable(hitsContainersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="hitsContainers")
    @JsonIgnore
    public CollectionPage<SearchHitsContainer> getHitsContainers(HttpRequestOptions options) {
        return new CollectionPage<SearchHitsContainer>(contextPath, SearchHitsContainer.class, hitsContainers, Optional.ofNullable(hitsContainersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> searchTerms;
        private String searchTermsNextLink;
        private List<SearchHitsContainer> hitsContainers;
        private String hitsContainersNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder searchTerms(List<String> searchTerms) {
            this.searchTerms = searchTerms;
            this.changedFields = changedFields.add("searchTerms");
            return this;
        }

        public Builder searchTerms(String... searchTerms) {
            return searchTerms(Arrays.asList(searchTerms));
        }

        public Builder searchTermsNextLink(String searchTermsNextLink) {
            this.searchTermsNextLink = searchTermsNextLink;
            this.changedFields = changedFields.add("searchTerms");
            return this;
        }

        public Builder hitsContainers(List<SearchHitsContainer> hitsContainers) {
            this.hitsContainers = hitsContainers;
            this.changedFields = changedFields.add("hitsContainers");
            return this;
        }

        public Builder hitsContainers(SearchHitsContainer... hitsContainers) {
            return hitsContainers(Arrays.asList(hitsContainers));
        }

        public Builder hitsContainersNextLink(String hitsContainersNextLink) {
            this.hitsContainersNextLink = hitsContainersNextLink;
            this.changedFields = changedFields.add("hitsContainers");
            return this;
        }

        public SearchResponse build() {
            SearchResponse _x = new SearchResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.searchResponse";
            _x.searchTerms = searchTerms;
            _x.searchTermsNextLink = searchTermsNextLink;
            _x.hitsContainers = hitsContainers;
            _x.hitsContainersNextLink = hitsContainersNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchResponse[");
        b.append("searchTerms=");
        b.append(this.searchTerms);
        b.append(", ");
        b.append("hitsContainers=");
        b.append(this.hitsContainers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
