package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EntityType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "entityTypes", 
    "contentSources", 
    "query", 
    "from", 
    "size", 
    "stored_fields", 
    "enableTopResults"})
@JsonInclude(Include.NON_NULL)
public class SearchRequest implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("entityTypes")
    protected List<EntityType> entityTypes;

    @JsonProperty("entityTypes@nextLink")
    protected String entityTypesNextLink;

    @JsonProperty("contentSources")
    protected List<String> contentSources;

    @JsonProperty("contentSources@nextLink")
    protected String contentSourcesNextLink;

    @JsonProperty("query")
    protected SearchQuery query;

    @JsonProperty("from")
    protected Integer from;

    @JsonProperty("size")
    protected Integer size;

    @JsonProperty("stored_fields")
    protected List<String> stored_fields;

    @JsonProperty("stored_fields@nextLink")
    protected String stored_fieldsNextLink;

    @JsonProperty("enableTopResults")
    protected Boolean enableTopResults;

    protected SearchRequest() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchRequest";
    }

    @Property(name="entityTypes")
    @JsonIgnore
    public CollectionPage<EntityType> getEntityTypes() {
        return new CollectionPage<EntityType>(contextPath, EntityType.class, entityTypes, Optional.ofNullable(entityTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="entityTypes")
    @JsonIgnore
    public CollectionPage<EntityType> getEntityTypes(HttpRequestOptions options) {
        return new CollectionPage<EntityType>(contextPath, EntityType.class, entityTypes, Optional.ofNullable(entityTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="contentSources")
    @JsonIgnore
    public CollectionPage<String> getContentSources() {
        return new CollectionPage<String>(contextPath, String.class, contentSources, Optional.ofNullable(contentSourcesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="contentSources")
    @JsonIgnore
    public CollectionPage<String> getContentSources(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, contentSources, Optional.ofNullable(contentSourcesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="query")
    @JsonIgnore
    public Optional<SearchQuery> getQuery() {
        return Optional.ofNullable(query);
    }

    public SearchRequest withQuery(SearchQuery query) {
        SearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchRequest");
        _x.query = query;
        return _x;
    }

    @Property(name="from")
    @JsonIgnore
    public Optional<Integer> getFrom() {
        return Optional.ofNullable(from);
    }

    public SearchRequest withFrom(Integer from) {
        SearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchRequest");
        _x.from = from;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Integer> getSize() {
        return Optional.ofNullable(size);
    }

    public SearchRequest withSize(Integer size) {
        SearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchRequest");
        _x.size = size;
        return _x;
    }

    @Property(name="stored_fields")
    @JsonIgnore
    public CollectionPage<String> getStored_fields() {
        return new CollectionPage<String>(contextPath, String.class, stored_fields, Optional.ofNullable(stored_fieldsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="stored_fields")
    @JsonIgnore
    public CollectionPage<String> getStored_fields(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, stored_fields, Optional.ofNullable(stored_fieldsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="enableTopResults")
    @JsonIgnore
    public Optional<Boolean> getEnableTopResults() {
        return Optional.ofNullable(enableTopResults);
    }

    public SearchRequest withEnableTopResults(Boolean enableTopResults) {
        SearchRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchRequest");
        _x.enableTopResults = enableTopResults;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<EntityType> entityTypes;
        private String entityTypesNextLink;
        private List<String> contentSources;
        private String contentSourcesNextLink;
        private SearchQuery query;
        private Integer from;
        private Integer size;
        private List<String> stored_fields;
        private String stored_fieldsNextLink;
        private Boolean enableTopResults;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder entityTypes(List<EntityType> entityTypes) {
            this.entityTypes = entityTypes;
            this.changedFields = changedFields.add("entityTypes");
            return this;
        }

        public Builder entityTypes(EntityType... entityTypes) {
            return entityTypes(Arrays.asList(entityTypes));
        }

        public Builder entityTypesNextLink(String entityTypesNextLink) {
            this.entityTypesNextLink = entityTypesNextLink;
            this.changedFields = changedFields.add("entityTypes");
            return this;
        }

        public Builder contentSources(List<String> contentSources) {
            this.contentSources = contentSources;
            this.changedFields = changedFields.add("contentSources");
            return this;
        }

        public Builder contentSources(String... contentSources) {
            return contentSources(Arrays.asList(contentSources));
        }

        public Builder contentSourcesNextLink(String contentSourcesNextLink) {
            this.contentSourcesNextLink = contentSourcesNextLink;
            this.changedFields = changedFields.add("contentSources");
            return this;
        }

        public Builder query(SearchQuery query) {
            this.query = query;
            this.changedFields = changedFields.add("query");
            return this;
        }

        public Builder from(Integer from) {
            this.from = from;
            this.changedFields = changedFields.add("from");
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder stored_fields(List<String> stored_fields) {
            this.stored_fields = stored_fields;
            this.changedFields = changedFields.add("stored_fields");
            return this;
        }

        public Builder stored_fields(String... stored_fields) {
            return stored_fields(Arrays.asList(stored_fields));
        }

        public Builder stored_fieldsNextLink(String stored_fieldsNextLink) {
            this.stored_fieldsNextLink = stored_fieldsNextLink;
            this.changedFields = changedFields.add("stored_fields");
            return this;
        }

        public Builder enableTopResults(Boolean enableTopResults) {
            this.enableTopResults = enableTopResults;
            this.changedFields = changedFields.add("enableTopResults");
            return this;
        }

        public SearchRequest build() {
            SearchRequest _x = new SearchRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.searchRequest";
            _x.entityTypes = entityTypes;
            _x.entityTypesNextLink = entityTypesNextLink;
            _x.contentSources = contentSources;
            _x.contentSourcesNextLink = contentSourcesNextLink;
            _x.query = query;
            _x.from = from;
            _x.size = size;
            _x.stored_fields = stored_fields;
            _x.stored_fieldsNextLink = stored_fieldsNextLink;
            _x.enableTopResults = enableTopResults;
            return _x;
        }
    }

    private SearchRequest _copy() {
        SearchRequest _x = new SearchRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.entityTypes = entityTypes;
        _x.contentSources = contentSources;
        _x.query = query;
        _x.from = from;
        _x.size = size;
        _x.stored_fields = stored_fields;
        _x.enableTopResults = enableTopResults;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchRequest[");
        b.append("entityTypes=");
        b.append(this.entityTypes);
        b.append(", ");
        b.append("contentSources=");
        b.append(this.contentSources);
        b.append(", ");
        b.append("query=");
        b.append(this.query);
        b.append(", ");
        b.append("from=");
        b.append(this.from);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("stored_fields=");
        b.append(this.stored_fields);
        b.append(", ");
        b.append("enableTopResults=");
        b.append(this.enableTopResults);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
