package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "hits", 
    "total", 
    "moreResultsAvailable"})
@JsonInclude(Include.NON_NULL)
public class SearchHitsContainer implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("hits")
    protected List<SearchHit> hits;

    @JsonProperty("hits@nextLink")
    protected String hitsNextLink;

    @JsonProperty("total")
    protected Integer total;

    @JsonProperty("moreResultsAvailable")
    protected Boolean moreResultsAvailable;

    protected SearchHitsContainer() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchHitsContainer";
    }

    @Property(name="hits")
    @JsonIgnore
    public CollectionPage<SearchHit> getHits() {
        return new CollectionPage<SearchHit>(contextPath, SearchHit.class, hits, Optional.ofNullable(hitsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="hits")
    @JsonIgnore
    public CollectionPage<SearchHit> getHits(HttpRequestOptions options) {
        return new CollectionPage<SearchHit>(contextPath, SearchHit.class, hits, Optional.ofNullable(hitsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="total")
    @JsonIgnore
    public Optional<Integer> getTotal() {
        return Optional.ofNullable(total);
    }

    public SearchHitsContainer withTotal(Integer total) {
        SearchHitsContainer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHitsContainer");
        _x.total = total;
        return _x;
    }

    @Property(name="moreResultsAvailable")
    @JsonIgnore
    public Optional<Boolean> getMoreResultsAvailable() {
        return Optional.ofNullable(moreResultsAvailable);
    }

    public SearchHitsContainer withMoreResultsAvailable(Boolean moreResultsAvailable) {
        SearchHitsContainer _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHitsContainer");
        _x.moreResultsAvailable = moreResultsAvailable;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<SearchHit> hits;
        private String hitsNextLink;
        private Integer total;
        private Boolean moreResultsAvailable;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder hits(List<SearchHit> hits) {
            this.hits = hits;
            this.changedFields = changedFields.add("hits");
            return this;
        }

        public Builder hits(SearchHit... hits) {
            return hits(Arrays.asList(hits));
        }

        public Builder hitsNextLink(String hitsNextLink) {
            this.hitsNextLink = hitsNextLink;
            this.changedFields = changedFields.add("hits");
            return this;
        }

        public Builder total(Integer total) {
            this.total = total;
            this.changedFields = changedFields.add("total");
            return this;
        }

        public Builder moreResultsAvailable(Boolean moreResultsAvailable) {
            this.moreResultsAvailable = moreResultsAvailable;
            this.changedFields = changedFields.add("moreResultsAvailable");
            return this;
        }

        public SearchHitsContainer build() {
            SearchHitsContainer _x = new SearchHitsContainer();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.searchHitsContainer";
            _x.hits = hits;
            _x.hitsNextLink = hitsNextLink;
            _x.total = total;
            _x.moreResultsAvailable = moreResultsAvailable;
            return _x;
        }
    }

    private SearchHitsContainer _copy() {
        SearchHitsContainer _x = new SearchHitsContainer();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.hits = hits;
        _x.total = total;
        _x.moreResultsAvailable = moreResultsAvailable;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchHitsContainer[");
        b.append("hits=");
        b.append(this.hits);
        b.append(", ");
        b.append("total=");
        b.append(this.total);
        b.append(", ");
        b.append("moreResultsAvailable=");
        b.append(this.moreResultsAvailable);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
