package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "_id", 
    "_score", 
    "_sortField", 
    "_summary", 
    "_source"})
@JsonInclude(Include.NON_NULL)
public class SearchHit implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("_id")
    protected String _id;

    @JsonProperty("_score")
    protected Integer _score;

    @JsonProperty("_sortField")
    protected String _sortField;

    @JsonProperty("_summary")
    protected String _summary;

    @JsonProperty("_source")
    protected Entity _source;

    protected SearchHit() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.searchHit";
    }

    @Property(name="_id")
    @JsonIgnore
    public Optional<String> get_id() {
        return Optional.ofNullable(_id);
    }

    public SearchHit with_id(String _id) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x._id = _id;
        return _x;
    }

    @Property(name="_score")
    @JsonIgnore
    public Optional<Integer> get_score() {
        return Optional.ofNullable(_score);
    }

    public SearchHit with_score(Integer _score) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x._score = _score;
        return _x;
    }

    @Property(name="_sortField")
    @JsonIgnore
    public Optional<String> get_sortField() {
        return Optional.ofNullable(_sortField);
    }

    public SearchHit with_sortField(String _sortField) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x._sortField = _sortField;
        return _x;
    }

    @Property(name="_summary")
    @JsonIgnore
    public Optional<String> get_summary() {
        return Optional.ofNullable(_summary);
    }

    public SearchHit with_summary(String _summary) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x._summary = _summary;
        return _x;
    }

    @Property(name="_source")
    @JsonIgnore
    public Optional<Entity> get_source() {
        return Optional.ofNullable(_source);
    }

    public SearchHit with_source(Entity _source) {
        SearchHit _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.searchHit");
        _x._source = _source;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _id;
        private Integer _score;
        private String _sortField;
        private String _summary;
        private Entity _source;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _id(String _id) {
            this._id = _id;
            this.changedFields = changedFields.add("_id");
            return this;
        }

        public Builder _score(Integer _score) {
            this._score = _score;
            this.changedFields = changedFields.add("_score");
            return this;
        }

        public Builder _sortField(String _sortField) {
            this._sortField = _sortField;
            this.changedFields = changedFields.add("_sortField");
            return this;
        }

        public Builder _summary(String _summary) {
            this._summary = _summary;
            this.changedFields = changedFields.add("_summary");
            return this;
        }

        public Builder _source(Entity _source) {
            this._source = _source;
            this.changedFields = changedFields.add("_source");
            return this;
        }

        public SearchHit build() {
            SearchHit _x = new SearchHit();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.searchHit";
            _x._id = _id;
            _x._score = _score;
            _x._sortField = _sortField;
            _x._summary = _summary;
            _x._source = _source;
            return _x;
        }
    }

    private SearchHit _copy() {
        SearchHit _x = new SearchHit();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x._id = _id;
        _x._score = _score;
        _x._sortField = _sortField;
        _x._summary = _summary;
        _x._source = _source;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchHit[");
        b.append("_id=");
        b.append(this._id);
        b.append(", ");
        b.append("_score=");
        b.append(this._score);
        b.append(", ");
        b.append("_sortField=");
        b.append(this._sortField);
        b.append(", ");
        b.append("_summary=");
        b.append(this._summary);
        b.append(", ");
        b.append("_source=");
        b.append(this._source);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
