package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "scheduleId", 
    "scheduleItems", 
    "availabilityView", 
    "error", 
    "workingHours"})
@JsonInclude(Include.NON_NULL)
public class ScheduleInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("scheduleId")
    protected String scheduleId;

    @JsonProperty("scheduleItems")
    protected List<ScheduleItem> scheduleItems;

    @JsonProperty("scheduleItems@nextLink")
    protected String scheduleItemsNextLink;

    @JsonProperty("availabilityView")
    protected String availabilityView;

    @JsonProperty("error")
    protected FreeBusyError error;

    @JsonProperty("workingHours")
    protected WorkingHours workingHours;

    protected ScheduleInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.scheduleInformation";
    }

    @Property(name="scheduleId")
    @JsonIgnore
    public Optional<String> getScheduleId() {
        return Optional.ofNullable(scheduleId);
    }

    public ScheduleInformation withScheduleId(String scheduleId) {
        ScheduleInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleInformation");
        _x.scheduleId = scheduleId;
        return _x;
    }

    @Property(name="scheduleItems")
    @JsonIgnore
    public CollectionPage<ScheduleItem> getScheduleItems() {
        return new CollectionPage<ScheduleItem>(contextPath, ScheduleItem.class, scheduleItems, Optional.ofNullable(scheduleItemsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="scheduleItems")
    @JsonIgnore
    public CollectionPage<ScheduleItem> getScheduleItems(HttpRequestOptions options) {
        return new CollectionPage<ScheduleItem>(contextPath, ScheduleItem.class, scheduleItems, Optional.ofNullable(scheduleItemsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="availabilityView")
    @JsonIgnore
    public Optional<String> getAvailabilityView() {
        return Optional.ofNullable(availabilityView);
    }

    public ScheduleInformation withAvailabilityView(String availabilityView) {
        ScheduleInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleInformation");
        _x.availabilityView = availabilityView;
        return _x;
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<FreeBusyError> getError() {
        return Optional.ofNullable(error);
    }

    public ScheduleInformation withError(FreeBusyError error) {
        ScheduleInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleInformation");
        _x.error = error;
        return _x;
    }

    @Property(name="workingHours")
    @JsonIgnore
    public Optional<WorkingHours> getWorkingHours() {
        return Optional.ofNullable(workingHours);
    }

    public ScheduleInformation withWorkingHours(WorkingHours workingHours) {
        ScheduleInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleInformation");
        _x.workingHours = workingHours;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String scheduleId;
        private List<ScheduleItem> scheduleItems;
        private String scheduleItemsNextLink;
        private String availabilityView;
        private FreeBusyError error;
        private WorkingHours workingHours;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            this.changedFields = changedFields.add("scheduleId");
            return this;
        }

        public Builder scheduleItems(List<ScheduleItem> scheduleItems) {
            this.scheduleItems = scheduleItems;
            this.changedFields = changedFields.add("scheduleItems");
            return this;
        }

        public Builder scheduleItems(ScheduleItem... scheduleItems) {
            return scheduleItems(Arrays.asList(scheduleItems));
        }

        public Builder scheduleItemsNextLink(String scheduleItemsNextLink) {
            this.scheduleItemsNextLink = scheduleItemsNextLink;
            this.changedFields = changedFields.add("scheduleItems");
            return this;
        }

        public Builder availabilityView(String availabilityView) {
            this.availabilityView = availabilityView;
            this.changedFields = changedFields.add("availabilityView");
            return this;
        }

        public Builder error(FreeBusyError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder workingHours(WorkingHours workingHours) {
            this.workingHours = workingHours;
            this.changedFields = changedFields.add("workingHours");
            return this;
        }

        public ScheduleInformation build() {
            ScheduleInformation _x = new ScheduleInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.scheduleInformation";
            _x.scheduleId = scheduleId;
            _x.scheduleItems = scheduleItems;
            _x.scheduleItemsNextLink = scheduleItemsNextLink;
            _x.availabilityView = availabilityView;
            _x.error = error;
            _x.workingHours = workingHours;
            return _x;
        }
    }

    private ScheduleInformation _copy() {
        ScheduleInformation _x = new ScheduleInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.scheduleId = scheduleId;
        _x.scheduleItems = scheduleItems;
        _x.availabilityView = availabilityView;
        _x.error = error;
        _x.workingHours = workingHours;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ScheduleInformation[");
        b.append("scheduleId=");
        b.append(this.scheduleId);
        b.append(", ");
        b.append("scheduleItems=");
        b.append(this.scheduleItems);
        b.append(", ");
        b.append("availabilityView=");
        b.append(this.availabilityView);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("workingHours=");
        b.append(this.workingHours);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
