package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ScheduleEntityTheme;

@JsonPropertyOrder({
    "@odata.type", 
    "startDateTime", 
    "endDateTime", 
    "theme"})
@JsonInclude(Include.NON_NULL)
public class ScheduleEntity implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("theme")
    protected ScheduleEntityTheme theme;

    protected ScheduleEntity() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.scheduleEntity";
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public ScheduleEntity withStartDateTime(OffsetDateTime startDateTime) {
        ScheduleEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleEntity");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public ScheduleEntity withEndDateTime(OffsetDateTime endDateTime) {
        ScheduleEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleEntity");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="theme")
    @JsonIgnore
    public Optional<ScheduleEntityTheme> getTheme() {
        return Optional.ofNullable(theme);
    }

    public ScheduleEntity withTheme(ScheduleEntityTheme theme) {
        ScheduleEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleEntity");
        _x.theme = theme;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime startDateTime;
        private OffsetDateTime endDateTime;
        private ScheduleEntityTheme theme;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder theme(ScheduleEntityTheme theme) {
            this.theme = theme;
            this.changedFields = changedFields.add("theme");
            return this;
        }

        public ScheduleEntity build() {
            ScheduleEntity _x = new ScheduleEntity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.scheduleEntity";
            _x.startDateTime = startDateTime;
            _x.endDateTime = endDateTime;
            _x.theme = theme;
            return _x;
        }
    }

    private ScheduleEntity _copy() {
        ScheduleEntity _x = new ScheduleEntity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.startDateTime = startDateTime;
        _x.endDateTime = endDateTime;
        _x.theme = theme;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ScheduleEntity[");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("theme=");
        b.append(this.theme);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
