package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "roleId", 
    "roleName", 
    "temporarySuccess", 
    "temporaryFail", 
    "permanentSuccess", 
    "permanentFail", 
    "removeSuccess", 
    "removeFail", 
    "unknownFail"})
@JsonInclude(Include.NON_NULL)
public class RoleSuccessStatistics implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("roleId")
    protected String roleId;

    @JsonProperty("roleName")
    protected String roleName;

    @JsonProperty("temporarySuccess")
    protected Long temporarySuccess;

    @JsonProperty("temporaryFail")
    protected Long temporaryFail;

    @JsonProperty("permanentSuccess")
    protected Long permanentSuccess;

    @JsonProperty("permanentFail")
    protected Long permanentFail;

    @JsonProperty("removeSuccess")
    protected Long removeSuccess;

    @JsonProperty("removeFail")
    protected Long removeFail;

    @JsonProperty("unknownFail")
    protected Long unknownFail;

    protected RoleSuccessStatistics() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.roleSuccessStatistics";
    }

    @Property(name="roleId")
    @JsonIgnore
    public Optional<String> getRoleId() {
        return Optional.ofNullable(roleId);
    }

    public RoleSuccessStatistics withRoleId(String roleId) {
        RoleSuccessStatistics _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleSuccessStatistics");
        _x.roleId = roleId;
        return _x;
    }

    @Property(name="roleName")
    @JsonIgnore
    public Optional<String> getRoleName() {
        return Optional.ofNullable(roleName);
    }

    public RoleSuccessStatistics withRoleName(String roleName) {
        RoleSuccessStatistics _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleSuccessStatistics");
        _x.roleName = roleName;
        return _x;
    }

    @Property(name="temporarySuccess")
    @JsonIgnore
    public Optional<Long> getTemporarySuccess() {
        return Optional.ofNullable(temporarySuccess);
    }

    public RoleSuccessStatistics withTemporarySuccess(Long temporarySuccess) {
        RoleSuccessStatistics _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleSuccessStatistics");
        _x.temporarySuccess = temporarySuccess;
        return _x;
    }

    @Property(name="temporaryFail")
    @JsonIgnore
    public Optional<Long> getTemporaryFail() {
        return Optional.ofNullable(temporaryFail);
    }

    public RoleSuccessStatistics withTemporaryFail(Long temporaryFail) {
        RoleSuccessStatistics _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleSuccessStatistics");
        _x.temporaryFail = temporaryFail;
        return _x;
    }

    @Property(name="permanentSuccess")
    @JsonIgnore
    public Optional<Long> getPermanentSuccess() {
        return Optional.ofNullable(permanentSuccess);
    }

    public RoleSuccessStatistics withPermanentSuccess(Long permanentSuccess) {
        RoleSuccessStatistics _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleSuccessStatistics");
        _x.permanentSuccess = permanentSuccess;
        return _x;
    }

    @Property(name="permanentFail")
    @JsonIgnore
    public Optional<Long> getPermanentFail() {
        return Optional.ofNullable(permanentFail);
    }

    public RoleSuccessStatistics withPermanentFail(Long permanentFail) {
        RoleSuccessStatistics _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleSuccessStatistics");
        _x.permanentFail = permanentFail;
        return _x;
    }

    @Property(name="removeSuccess")
    @JsonIgnore
    public Optional<Long> getRemoveSuccess() {
        return Optional.ofNullable(removeSuccess);
    }

    public RoleSuccessStatistics withRemoveSuccess(Long removeSuccess) {
        RoleSuccessStatistics _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleSuccessStatistics");
        _x.removeSuccess = removeSuccess;
        return _x;
    }

    @Property(name="removeFail")
    @JsonIgnore
    public Optional<Long> getRemoveFail() {
        return Optional.ofNullable(removeFail);
    }

    public RoleSuccessStatistics withRemoveFail(Long removeFail) {
        RoleSuccessStatistics _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleSuccessStatistics");
        _x.removeFail = removeFail;
        return _x;
    }

    @Property(name="unknownFail")
    @JsonIgnore
    public Optional<Long> getUnknownFail() {
        return Optional.ofNullable(unknownFail);
    }

    public RoleSuccessStatistics withUnknownFail(Long unknownFail) {
        RoleSuccessStatistics _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleSuccessStatistics");
        _x.unknownFail = unknownFail;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String roleId;
        private String roleName;
        private Long temporarySuccess;
        private Long temporaryFail;
        private Long permanentSuccess;
        private Long permanentFail;
        private Long removeSuccess;
        private Long removeFail;
        private Long unknownFail;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder roleId(String roleId) {
            this.roleId = roleId;
            this.changedFields = changedFields.add("roleId");
            return this;
        }

        public Builder roleName(String roleName) {
            this.roleName = roleName;
            this.changedFields = changedFields.add("roleName");
            return this;
        }

        public Builder temporarySuccess(Long temporarySuccess) {
            this.temporarySuccess = temporarySuccess;
            this.changedFields = changedFields.add("temporarySuccess");
            return this;
        }

        public Builder temporaryFail(Long temporaryFail) {
            this.temporaryFail = temporaryFail;
            this.changedFields = changedFields.add("temporaryFail");
            return this;
        }

        public Builder permanentSuccess(Long permanentSuccess) {
            this.permanentSuccess = permanentSuccess;
            this.changedFields = changedFields.add("permanentSuccess");
            return this;
        }

        public Builder permanentFail(Long permanentFail) {
            this.permanentFail = permanentFail;
            this.changedFields = changedFields.add("permanentFail");
            return this;
        }

        public Builder removeSuccess(Long removeSuccess) {
            this.removeSuccess = removeSuccess;
            this.changedFields = changedFields.add("removeSuccess");
            return this;
        }

        public Builder removeFail(Long removeFail) {
            this.removeFail = removeFail;
            this.changedFields = changedFields.add("removeFail");
            return this;
        }

        public Builder unknownFail(Long unknownFail) {
            this.unknownFail = unknownFail;
            this.changedFields = changedFields.add("unknownFail");
            return this;
        }

        public RoleSuccessStatistics build() {
            RoleSuccessStatistics _x = new RoleSuccessStatistics();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.roleSuccessStatistics";
            _x.roleId = roleId;
            _x.roleName = roleName;
            _x.temporarySuccess = temporarySuccess;
            _x.temporaryFail = temporaryFail;
            _x.permanentSuccess = permanentSuccess;
            _x.permanentFail = permanentFail;
            _x.removeSuccess = removeSuccess;
            _x.removeFail = removeFail;
            _x.unknownFail = unknownFail;
            return _x;
        }
    }

    private RoleSuccessStatistics _copy() {
        RoleSuccessStatistics _x = new RoleSuccessStatistics();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.roleId = roleId;
        _x.roleName = roleName;
        _x.temporarySuccess = temporarySuccess;
        _x.temporaryFail = temporaryFail;
        _x.permanentSuccess = permanentSuccess;
        _x.permanentFail = permanentFail;
        _x.removeSuccess = removeSuccess;
        _x.removeFail = removeFail;
        _x.unknownFail = unknownFail;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RoleSuccessStatistics[");
        b.append("roleId=");
        b.append(this.roleId);
        b.append(", ");
        b.append("roleName=");
        b.append(this.roleName);
        b.append(", ");
        b.append("temporarySuccess=");
        b.append(this.temporarySuccess);
        b.append(", ");
        b.append("temporaryFail=");
        b.append(this.temporaryFail);
        b.append(", ");
        b.append("permanentSuccess=");
        b.append(this.permanentSuccess);
        b.append(", ");
        b.append("permanentFail=");
        b.append(this.permanentFail);
        b.append(", ");
        b.append("removeSuccess=");
        b.append(this.removeSuccess);
        b.append(", ");
        b.append("removeFail=");
        b.append(this.removeFail);
        b.append(", ");
        b.append("unknownFail=");
        b.append(this.unknownFail);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
