package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“A class containing the properties of Role Scope Tag Object.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "roleScopeTagId"})
@JsonInclude(Include.NON_NULL)
public class RoleScopeTagInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("roleScopeTagId")
    protected String roleScopeTagId;

    protected RoleScopeTagInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.roleScopeTagInfo";
    }

    /**
     * <i>“Scope Tag Display name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Scope Tag Display name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public RoleScopeTagInfo withDisplayName(String displayName) {
        RoleScopeTagInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleScopeTagInfo");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Scope Tag Id.”</i>
     * 
     * @return property roleScopeTagId
     */
    @Property(name="roleScopeTagId")
    @JsonIgnore
    public Optional<String> getRoleScopeTagId() {
        return Optional.ofNullable(roleScopeTagId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Scope Tag Id.”</i>
     * 
     * @param roleScopeTagId
     *            new value of {@code roleScopeTagId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagId} field changed
     */
    public RoleScopeTagInfo withRoleScopeTagId(String roleScopeTagId) {
        RoleScopeTagInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleScopeTagInfo");
        _x.roleScopeTagId = roleScopeTagId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String roleScopeTagId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Scope Tag Display name.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Scope Tag Id.”</i>
         * 
         * @param roleScopeTagId
         *            value of {@code roleScopeTagId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagId(String roleScopeTagId) {
            this.roleScopeTagId = roleScopeTagId;
            this.changedFields = changedFields.add("roleScopeTagId");
            return this;
        }

        public RoleScopeTagInfo build() {
            RoleScopeTagInfo _x = new RoleScopeTagInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.roleScopeTagInfo";
            _x.displayName = displayName;
            _x.roleScopeTagId = roleScopeTagId;
            return _x;
        }
    }

    private RoleScopeTagInfo _copy() {
        RoleScopeTagInfo _x = new RoleScopeTagInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.roleScopeTagId = roleScopeTagId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RoleScopeTagInfo[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("roleScopeTagId=");
        b.append(this.roleScopeTagId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
