package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RiskDetail;
import odata.msgraph.client.beta.enums.RiskEventType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "eventTypes", 
    "riskEventTypes", 
    "detail"})
@JsonInclude(Include.NON_NULL)
public class RiskUserActivity implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("eventTypes")
    protected List<RiskEventType> eventTypes;

    @JsonProperty("eventTypes@nextLink")
    protected String eventTypesNextLink;

    @JsonProperty("riskEventTypes")
    protected List<String> riskEventTypes;

    @JsonProperty("riskEventTypes@nextLink")
    protected String riskEventTypesNextLink;

    @JsonProperty("detail")
    protected RiskDetail detail;

    protected RiskUserActivity() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.riskUserActivity";
    }

    @Property(name="eventTypes")
    @JsonIgnore
    public CollectionPage<RiskEventType> getEventTypes() {
        return new CollectionPage<RiskEventType>(contextPath, RiskEventType.class, eventTypes, Optional.ofNullable(eventTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="eventTypes")
    @JsonIgnore
    public CollectionPage<RiskEventType> getEventTypes(HttpRequestOptions options) {
        return new CollectionPage<RiskEventType>(contextPath, RiskEventType.class, eventTypes, Optional.ofNullable(eventTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="riskEventTypes")
    @JsonIgnore
    public CollectionPage<String> getRiskEventTypes() {
        return new CollectionPage<String>(contextPath, String.class, riskEventTypes, Optional.ofNullable(riskEventTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="riskEventTypes")
    @JsonIgnore
    public CollectionPage<String> getRiskEventTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, riskEventTypes, Optional.ofNullable(riskEventTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="detail")
    @JsonIgnore
    public Optional<RiskDetail> getDetail() {
        return Optional.ofNullable(detail);
    }

    public RiskUserActivity withDetail(RiskDetail detail) {
        RiskUserActivity _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskUserActivity");
        _x.detail = detail;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<RiskEventType> eventTypes;
        private String eventTypesNextLink;
        private List<String> riskEventTypes;
        private String riskEventTypesNextLink;
        private RiskDetail detail;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder eventTypes(List<RiskEventType> eventTypes) {
            this.eventTypes = eventTypes;
            this.changedFields = changedFields.add("eventTypes");
            return this;
        }

        public Builder eventTypes(RiskEventType... eventTypes) {
            return eventTypes(Arrays.asList(eventTypes));
        }

        public Builder eventTypesNextLink(String eventTypesNextLink) {
            this.eventTypesNextLink = eventTypesNextLink;
            this.changedFields = changedFields.add("eventTypes");
            return this;
        }

        public Builder riskEventTypes(List<String> riskEventTypes) {
            this.riskEventTypes = riskEventTypes;
            this.changedFields = changedFields.add("riskEventTypes");
            return this;
        }

        public Builder riskEventTypes(String... riskEventTypes) {
            return riskEventTypes(Arrays.asList(riskEventTypes));
        }

        public Builder riskEventTypesNextLink(String riskEventTypesNextLink) {
            this.riskEventTypesNextLink = riskEventTypesNextLink;
            this.changedFields = changedFields.add("riskEventTypes");
            return this;
        }

        public Builder detail(RiskDetail detail) {
            this.detail = detail;
            this.changedFields = changedFields.add("detail");
            return this;
        }

        public RiskUserActivity build() {
            RiskUserActivity _x = new RiskUserActivity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.riskUserActivity";
            _x.eventTypes = eventTypes;
            _x.eventTypesNextLink = eventTypesNextLink;
            _x.riskEventTypes = riskEventTypes;
            _x.riskEventTypesNextLink = riskEventTypesNextLink;
            _x.detail = detail;
            return _x;
        }
    }

    private RiskUserActivity _copy() {
        RiskUserActivity _x = new RiskUserActivity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.eventTypes = eventTypes;
        _x.riskEventTypes = riskEventTypes;
        _x.detail = detail;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RiskUserActivity[");
        b.append("eventTypes=");
        b.append(this.eventTypes);
        b.append(", ");
        b.append("riskEventTypes=");
        b.append(this.riskEventTypes);
        b.append(", ");
        b.append("detail=");
        b.append(this.detail);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
