package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ComplianceStatus;
import odata.msgraph.client.beta.enums.DeviceType;
import odata.msgraph.client.beta.enums.ManagedDeviceOwnerType;
import odata.msgraph.client.beta.enums.ManagementAgentType;


/**
 * <i>“ManagedDevices that are scheduled for retire”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "managedDeviceId", 
    "managedDeviceName", 
    "deviceType", 
    "complianceState", 
    "retireAfterDateTime", 
    "managementAgent", 
    "ownerType", 
    "deviceCompliancePolicyName", 
    "deviceCompliancePolicyId", 
    "roleScopeTagIds"})
@JsonInclude(Include.NON_NULL)
public class RetireScheduledManagedDevice implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("managedDeviceName")
    protected String managedDeviceName;

    @JsonProperty("deviceType")
    protected DeviceType deviceType;

    @JsonProperty("complianceState")
    protected ComplianceStatus complianceState;

    @JsonProperty("retireAfterDateTime")
    protected OffsetDateTime retireAfterDateTime;

    @JsonProperty("managementAgent")
    protected ManagementAgentType managementAgent;

    @JsonProperty("ownerType")
    protected ManagedDeviceOwnerType ownerType;

    @JsonProperty("deviceCompliancePolicyName")
    protected String deviceCompliancePolicyName;

    @JsonProperty("deviceCompliancePolicyId")
    protected String deviceCompliancePolicyId;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    protected RetireScheduledManagedDevice() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.retireScheduledManagedDevice";
    }

    /**
     * <i>“Key of the entity.”</i>
     * 
     * @return property id
     */
    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code id} field changed
     * . Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Key of the entity.”</i>
     * 
     * @param id
     *            new value of {@code id} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code id} field changed
     */
    public RetireScheduledManagedDevice withId(String id) {
        RetireScheduledManagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.retireScheduledManagedDevice");
        _x.id = id;
        return _x;
    }

    /**
     * <i>“Managed DeviceId”</i>
     * 
     * @return property managedDeviceId
     */
    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Managed DeviceId”</i>
     * 
     * @param managedDeviceId
     *            new value of {@code managedDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceId} field changed
     */
    public RetireScheduledManagedDevice withManagedDeviceId(String managedDeviceId) {
        RetireScheduledManagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.retireScheduledManagedDevice");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    /**
     * <i>“Managed Device Name”</i>
     * 
     * @return property managedDeviceName
     */
    @Property(name="managedDeviceName")
    @JsonIgnore
    public Optional<String> getManagedDeviceName() {
        return Optional.ofNullable(managedDeviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Managed Device Name”</i>
     * 
     * @param managedDeviceName
     *            new value of {@code managedDeviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceName} field changed
     */
    public RetireScheduledManagedDevice withManagedDeviceName(String managedDeviceName) {
        RetireScheduledManagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.retireScheduledManagedDevice");
        _x.managedDeviceName = managedDeviceName;
        return _x;
    }

    /**
     * <i>“Managed Device Device Type”</i>
     * 
     * @return property deviceType
     */
    @Property(name="deviceType")
    @JsonIgnore
    public Optional<DeviceType> getDeviceType() {
        return Optional.ofNullable(deviceType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Managed Device Device Type”</i>
     * 
     * @param deviceType
     *            new value of {@code deviceType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceType} field changed
     */
    public RetireScheduledManagedDevice withDeviceType(DeviceType deviceType) {
        RetireScheduledManagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.retireScheduledManagedDevice");
        _x.deviceType = deviceType;
        return _x;
    }

    /**
     * <i>“Managed Device ComplianceStatus”</i>
     * 
     * @return property complianceState
     */
    @Property(name="complianceState")
    @JsonIgnore
    public Optional<ComplianceStatus> getComplianceState() {
        return Optional.ofNullable(complianceState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code complianceState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Managed Device ComplianceStatus”</i>
     * 
     * @param complianceState
     *            new value of {@code complianceState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code complianceState} field changed
     */
    public RetireScheduledManagedDevice withComplianceState(ComplianceStatus complianceState) {
        RetireScheduledManagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.retireScheduledManagedDevice");
        _x.complianceState = complianceState;
        return _x;
    }

    /**
     * <i>“Managed Device Retire After DateTime”</i>
     * 
     * @return property retireAfterDateTime
     */
    @Property(name="retireAfterDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRetireAfterDateTime() {
        return Optional.ofNullable(retireAfterDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * retireAfterDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Managed Device Retire After DateTime”</i>
     * 
     * @param retireAfterDateTime
     *            new value of {@code retireAfterDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code retireAfterDateTime} field changed
     */
    public RetireScheduledManagedDevice withRetireAfterDateTime(OffsetDateTime retireAfterDateTime) {
        RetireScheduledManagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.retireScheduledManagedDevice");
        _x.retireAfterDateTime = retireAfterDateTime;
        return _x;
    }

    /**
     * <i>“Managed Device ManagementAgentType”</i>
     * 
     * @return property managementAgent
     */
    @Property(name="managementAgent")
    @JsonIgnore
    public Optional<ManagementAgentType> getManagementAgent() {
        return Optional.ofNullable(managementAgent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managementAgent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Managed Device ManagementAgentType”</i>
     * 
     * @param managementAgent
     *            new value of {@code managementAgent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managementAgent} field changed
     */
    public RetireScheduledManagedDevice withManagementAgent(ManagementAgentType managementAgent) {
        RetireScheduledManagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.retireScheduledManagedDevice");
        _x.managementAgent = managementAgent;
        return _x;
    }

    /**
     * <i>“Managed Device ManagedDeviceOwnerType”</i>
     * 
     * @return property ownerType
     */
    @Property(name="ownerType")
    @JsonIgnore
    public Optional<ManagedDeviceOwnerType> getOwnerType() {
        return Optional.ofNullable(ownerType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ownerType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Managed Device ManagedDeviceOwnerType”</i>
     * 
     * @param ownerType
     *            new value of {@code ownerType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ownerType} field changed
     */
    public RetireScheduledManagedDevice withOwnerType(ManagedDeviceOwnerType ownerType) {
        RetireScheduledManagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.retireScheduledManagedDevice");
        _x.ownerType = ownerType;
        return _x;
    }

    /**
     * <i>“Device Compliance Policy Name”</i>
     * 
     * @return property deviceCompliancePolicyName
     */
    @Property(name="deviceCompliancePolicyName")
    @JsonIgnore
    public Optional<String> getDeviceCompliancePolicyName() {
        return Optional.ofNullable(deviceCompliancePolicyName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceCompliancePolicyName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device Compliance Policy Name”</i>
     * 
     * @param deviceCompliancePolicyName
     *            new value of {@code deviceCompliancePolicyName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCompliancePolicyName} field changed
     */
    public RetireScheduledManagedDevice withDeviceCompliancePolicyName(String deviceCompliancePolicyName) {
        RetireScheduledManagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.retireScheduledManagedDevice");
        _x.deviceCompliancePolicyName = deviceCompliancePolicyName;
        return _x;
    }

    /**
     * <i>“Device Compliance PolicyId”</i>
     * 
     * @return property deviceCompliancePolicyId
     */
    @Property(name="deviceCompliancePolicyId")
    @JsonIgnore
    public Optional<String> getDeviceCompliancePolicyId() {
        return Optional.ofNullable(deviceCompliancePolicyId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceCompliancePolicyId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device Compliance PolicyId”</i>
     * 
     * @param deviceCompliancePolicyId
     *            new value of {@code deviceCompliancePolicyId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCompliancePolicyId} field changed
     */
    public RetireScheduledManagedDevice withDeviceCompliancePolicyId(String deviceCompliancePolicyId) {
        RetireScheduledManagedDevice _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.retireScheduledManagedDevice");
        _x.deviceCompliancePolicyId = deviceCompliancePolicyId;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String managedDeviceId;
        private String managedDeviceName;
        private DeviceType deviceType;
        private ComplianceStatus complianceState;
        private OffsetDateTime retireAfterDateTime;
        private ManagementAgentType managementAgent;
        private ManagedDeviceOwnerType ownerType;
        private String deviceCompliancePolicyName;
        private String deviceCompliancePolicyId;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Key of the entity.”</i>
         * 
         * @param id
         *            value of {@code id} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Managed DeviceId”</i>
         * 
         * @param managedDeviceId
         *            value of {@code managedDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        /**
         * <i>“Managed Device Name”</i>
         * 
         * @param managedDeviceName
         *            value of {@code managedDeviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceName(String managedDeviceName) {
            this.managedDeviceName = managedDeviceName;
            this.changedFields = changedFields.add("managedDeviceName");
            return this;
        }

        /**
         * <i>“Managed Device Device Type”</i>
         * 
         * @param deviceType
         *            value of {@code deviceType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            this.changedFields = changedFields.add("deviceType");
            return this;
        }

        /**
         * <i>“Managed Device ComplianceStatus”</i>
         * 
         * @param complianceState
         *            value of {@code complianceState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder complianceState(ComplianceStatus complianceState) {
            this.complianceState = complianceState;
            this.changedFields = changedFields.add("complianceState");
            return this;
        }

        /**
         * <i>“Managed Device Retire After DateTime”</i>
         * 
         * @param retireAfterDateTime
         *            value of {@code retireAfterDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder retireAfterDateTime(OffsetDateTime retireAfterDateTime) {
            this.retireAfterDateTime = retireAfterDateTime;
            this.changedFields = changedFields.add("retireAfterDateTime");
            return this;
        }

        /**
         * <i>“Managed Device ManagementAgentType”</i>
         * 
         * @param managementAgent
         *            value of {@code managementAgent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managementAgent(ManagementAgentType managementAgent) {
            this.managementAgent = managementAgent;
            this.changedFields = changedFields.add("managementAgent");
            return this;
        }

        /**
         * <i>“Managed Device ManagedDeviceOwnerType”</i>
         * 
         * @param ownerType
         *            value of {@code ownerType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ownerType(ManagedDeviceOwnerType ownerType) {
            this.ownerType = ownerType;
            this.changedFields = changedFields.add("ownerType");
            return this;
        }

        /**
         * <i>“Device Compliance Policy Name”</i>
         * 
         * @param deviceCompliancePolicyName
         *            value of {@code deviceCompliancePolicyName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCompliancePolicyName(String deviceCompliancePolicyName) {
            this.deviceCompliancePolicyName = deviceCompliancePolicyName;
            this.changedFields = changedFields.add("deviceCompliancePolicyName");
            return this;
        }

        /**
         * <i>“Device Compliance PolicyId”</i>
         * 
         * @param deviceCompliancePolicyId
         *            value of {@code deviceCompliancePolicyId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCompliancePolicyId(String deviceCompliancePolicyId) {
            this.deviceCompliancePolicyId = deviceCompliancePolicyId;
            this.changedFields = changedFields.add("deviceCompliancePolicyId");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public RetireScheduledManagedDevice build() {
            RetireScheduledManagedDevice _x = new RetireScheduledManagedDevice();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.retireScheduledManagedDevice";
            _x.id = id;
            _x.managedDeviceId = managedDeviceId;
            _x.managedDeviceName = managedDeviceName;
            _x.deviceType = deviceType;
            _x.complianceState = complianceState;
            _x.retireAfterDateTime = retireAfterDateTime;
            _x.managementAgent = managementAgent;
            _x.ownerType = ownerType;
            _x.deviceCompliancePolicyName = deviceCompliancePolicyName;
            _x.deviceCompliancePolicyId = deviceCompliancePolicyId;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    private RetireScheduledManagedDevice _copy() {
        RetireScheduledManagedDevice _x = new RetireScheduledManagedDevice();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.managedDeviceId = managedDeviceId;
        _x.managedDeviceName = managedDeviceName;
        _x.deviceType = deviceType;
        _x.complianceState = complianceState;
        _x.retireAfterDateTime = retireAfterDateTime;
        _x.managementAgent = managementAgent;
        _x.ownerType = ownerType;
        _x.deviceCompliancePolicyName = deviceCompliancePolicyName;
        _x.deviceCompliancePolicyId = deviceCompliancePolicyId;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetireScheduledManagedDevice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("managedDeviceName=");
        b.append(this.managedDeviceName);
        b.append(", ");
        b.append("deviceType=");
        b.append(this.deviceType);
        b.append(", ");
        b.append("complianceState=");
        b.append(this.complianceState);
        b.append(", ");
        b.append("retireAfterDateTime=");
        b.append(this.retireAfterDateTime);
        b.append(", ");
        b.append("managementAgent=");
        b.append(this.managementAgent);
        b.append(", ");
        b.append("ownerType=");
        b.append(this.ownerType);
        b.append(", ");
        b.append("deviceCompliancePolicyName=");
        b.append(this.deviceCompliancePolicyName);
        b.append(", ");
        b.append("deviceCompliancePolicyId=");
        b.append(this.deviceCompliancePolicyId);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
