package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "code", 
    "subcode", 
    "message"})
@JsonInclude(Include.NON_NULL)
public class ResultInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("code")
    protected Integer code;

    @JsonProperty("subcode")
    protected Integer subcode;

    @JsonProperty("message")
    protected String message;

    protected ResultInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.ResultInfo";
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<Integer> getCode() {
        return Optional.ofNullable(code);
    }

    public ResultInfo withCode(Integer code) {
        ResultInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ResultInfo");
        _x.code = code;
        return _x;
    }

    @Property(name="subcode")
    @JsonIgnore
    public Optional<Integer> getSubcode() {
        return Optional.ofNullable(subcode);
    }

    public ResultInfo withSubcode(Integer subcode) {
        ResultInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ResultInfo");
        _x.subcode = subcode;
        return _x;
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public ResultInfo withMessage(String message) {
        ResultInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.ResultInfo");
        _x.message = message;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer code;
        private Integer subcode;
        private String message;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder code(Integer code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder subcode(Integer subcode) {
            this.subcode = subcode;
            this.changedFields = changedFields.add("subcode");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public ResultInfo build() {
            ResultInfo _x = new ResultInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.ResultInfo";
            _x.code = code;
            _x.subcode = subcode;
            _x.message = message;
            return _x;
        }
    }

    private ResultInfo _copy() {
        ResultInfo _x = new ResultInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.code = code;
        _x.subcode = subcode;
        _x.message = message;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResultInfo[");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("subcode=");
        b.append(this.subcode);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
