package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "name", 
    "description", 
    "rulePackageId", 
    "rulePackageType", 
    "publisherName"})
@JsonInclude(Include.NON_NULL)
public class ResponsibleSensitiveType implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("rulePackageId")
    protected String rulePackageId;

    @JsonProperty("rulePackageType")
    protected String rulePackageType;

    @JsonProperty("publisherName")
    protected String publisherName;

    protected ResponsibleSensitiveType() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.responsibleSensitiveType";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public ResponsibleSensitiveType withId(String id) {
        ResponsibleSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.responsibleSensitiveType");
        _x.id = id;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ResponsibleSensitiveType withName(String name) {
        ResponsibleSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.responsibleSensitiveType");
        _x.name = name;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ResponsibleSensitiveType withDescription(String description) {
        ResponsibleSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.responsibleSensitiveType");
        _x.description = description;
        return _x;
    }

    @Property(name="rulePackageId")
    @JsonIgnore
    public Optional<String> getRulePackageId() {
        return Optional.ofNullable(rulePackageId);
    }

    public ResponsibleSensitiveType withRulePackageId(String rulePackageId) {
        ResponsibleSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.responsibleSensitiveType");
        _x.rulePackageId = rulePackageId;
        return _x;
    }

    @Property(name="rulePackageType")
    @JsonIgnore
    public Optional<String> getRulePackageType() {
        return Optional.ofNullable(rulePackageType);
    }

    public ResponsibleSensitiveType withRulePackageType(String rulePackageType) {
        ResponsibleSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.responsibleSensitiveType");
        _x.rulePackageType = rulePackageType;
        return _x;
    }

    @Property(name="publisherName")
    @JsonIgnore
    public Optional<String> getPublisherName() {
        return Optional.ofNullable(publisherName);
    }

    public ResponsibleSensitiveType withPublisherName(String publisherName) {
        ResponsibleSensitiveType _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.responsibleSensitiveType");
        _x.publisherName = publisherName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private String description;
        private String rulePackageId;
        private String rulePackageType;
        private String publisherName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder rulePackageId(String rulePackageId) {
            this.rulePackageId = rulePackageId;
            this.changedFields = changedFields.add("rulePackageId");
            return this;
        }

        public Builder rulePackageType(String rulePackageType) {
            this.rulePackageType = rulePackageType;
            this.changedFields = changedFields.add("rulePackageType");
            return this;
        }

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            this.changedFields = changedFields.add("publisherName");
            return this;
        }

        public ResponsibleSensitiveType build() {
            ResponsibleSensitiveType _x = new ResponsibleSensitiveType();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.responsibleSensitiveType";
            _x.id = id;
            _x.name = name;
            _x.description = description;
            _x.rulePackageId = rulePackageId;
            _x.rulePackageType = rulePackageType;
            _x.publisherName = publisherName;
            return _x;
        }
    }

    private ResponsibleSensitiveType _copy() {
        ResponsibleSensitiveType _x = new ResponsibleSensitiveType();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        _x.description = description;
        _x.rulePackageId = rulePackageId;
        _x.rulePackageType = rulePackageType;
        _x.publisherName = publisherName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResponsibleSensitiveType[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("rulePackageId=");
        b.append(this.rulePackageId);
        b.append(", ");
        b.append("rulePackageType=");
        b.append(this.rulePackageType);
        b.append(", ");
        b.append("publisherName=");
        b.append(this.publisherName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
