package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "id", 
    "isEnabled", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class ResourceSpecificPermission implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("value")
    protected String value;

    protected ResourceSpecificPermission() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.resourceSpecificPermission";
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ResourceSpecificPermission withDescription(String description) {
        ResourceSpecificPermission _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceSpecificPermission");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ResourceSpecificPermission withDisplayName(String displayName) {
        ResourceSpecificPermission _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceSpecificPermission");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public ResourceSpecificPermission withId(String id) {
        ResourceSpecificPermission _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceSpecificPermission");
        _x.id = id;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public ResourceSpecificPermission withIsEnabled(Boolean isEnabled) {
        ResourceSpecificPermission _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceSpecificPermission");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public ResourceSpecificPermission withValue(String value) {
        ResourceSpecificPermission _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceSpecificPermission");
        _x.value = value;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String displayName;
        private String id;
        private Boolean isEnabled;
        private String value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public ResourceSpecificPermission build() {
            ResourceSpecificPermission _x = new ResourceSpecificPermission();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.resourceSpecificPermission";
            _x.description = description;
            _x.displayName = displayName;
            _x.id = id;
            _x.isEnabled = isEnabled;
            _x.value = value;
            return _x;
        }
    }

    private ResourceSpecificPermission _copy() {
        ResourceSpecificPermission _x = new ResourceSpecificPermission();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.description = description;
        _x.displayName = displayName;
        _x.id = id;
        _x.isEnabled = isEnabled;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceSpecificPermission[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
